/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DescriptorRegistry {
    private static ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final Map<DescriptorRegistryId, IDescriptorRegistry> REGISTRIES = new LinkedHashMap<DescriptorRegistryId, IDescriptorRegistry>();

    protected static IDescriptorRegistry getInstance() {
        return DescriptorRegistry.getDefaultDescriptorRegistry();
    }

    private static <T> T withReadLock(Callable<T> callable) {
        readWriteLock.readLock().lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
        finally {
            readWriteLock.readLock().unlock();
        }
    }

    public static <T> T withWriteLock(Callable<T> callable) {
        readWriteLock.writeLock().lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    public static void add(IDescriptorRegistry registry) {
        DescriptorRegistry.withWriteLock(() -> {
            DescriptorRegistryId otherLocal;
            DescriptorRegistryId registryId = registry.getId();
            if (REGISTRIES.containsKey(registry.getId())) {
                throw new IllegalStateException(String.format("There is a DescriptorRegistry booted with id [%s]", registryId));
            }
            if (registry.isLocal() && (otherLocal = DescriptorRegistry.lookupLocalRegistry()) != null) {
                throw new IllegalStateException(String.format("Tried to load another local DescriptorRegistry under [%s], already present under [%s]", registryId, otherLocal));
            }
            REGISTRIES.put(registry.getId(), registry);
            return null;
        });
    }

    public static void remove(DescriptorRegistryId id) {
        DescriptorRegistry.withWriteLock(() -> {
            REGISTRIES.remove(id);
            return null;
        });
    }

    public static void replaceRegistry(IDescriptorRegistry registry) {
        DescriptorRegistry.withWriteLock(() -> {
            DescriptorRegistryId otherLocal;
            DescriptorRegistryId registryId = registry.getId();
            if (registry.isLocal() && (otherLocal = DescriptorRegistry.lookupLocalRegistry()) != null) {
                throw new IllegalStateException(String.format("Tried to load another local DescriptorRegistry under [%s], already present under [%s]", registryId, otherLocal));
            }
            REGISTRIES.put(registryId, registry);
            return null;
        });
    }

    private static DescriptorRegistryId lookupLocalRegistry() {
        return DescriptorRegistry.withReadLock(() -> {
            for (IDescriptorRegistry descriptorRegistry : REGISTRIES.values()) {
                if (!descriptorRegistry.isLocal()) continue;
                return descriptorRegistry.getId();
            }
            return null;
        });
    }

    public static IDescriptorRegistry getDescriptorRegistry(DescriptorRegistryId id) {
        return DescriptorRegistry.withReadLock(() -> REGISTRIES.get(id));
    }

    static IDescriptorRegistry getDefaultDescriptorRegistry() {
        return DescriptorRegistry.withReadLock(() -> {
            if (REGISTRIES.keySet().isEmpty()) {
                throw new IllegalStateException("No DescriptorRegistries have been loaded.");
            }
            IDescriptorRegistry defaultRegistry = REGISTRIES.values().stream().filter(IDescriptorRegistry::isDefault).min(Comparator.comparingInt(IDescriptorRegistry::getOrder)).orElseGet(() -> REGISTRIES.values().iterator().next());
            return defaultRegistry;
        });
    }

    static IDescriptorRegistry getDescriptorRegistry(Type type) {
        return DescriptorRegistry.withReadLock(() -> {
            if (type.getTypeSource() == null) {
                throw new NullPointerException(String.format("The type [%s] is not registered with any DescriptorRegistry", type));
            }
            IDescriptorRegistry registry = REGISTRIES.get(type.getTypeSource());
            if (registry == null) {
                throw new NullPointerException(String.format("The type registry [%s] for type [%s] is not registered", type.getTypeSource(), type));
            }
            return registry;
        });
    }

    public static Descriptor getDescriptor(Type type) {
        return DescriptorRegistry.withReadLock(() -> {
            IDescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry(type);
            Descriptor descriptor = registry._getDescriptor(type);
            return descriptor;
        });
    }

    public static Descriptor getDescriptor(String prefixedName) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefixedName));
    }

    public static Descriptor getDescriptor(String prefix, String name) {
        return DescriptorRegistry.withReadLock(() -> DescriptorRegistry.getDescriptor(Type.valueOf(prefix, name)));
    }

    public static Collection<Descriptor> getDescriptors() {
        return DescriptorRegistry.withReadLock(() -> DescriptorRegistry.getDefaultDescriptorRegistry()._getDescriptors());
    }

    public static Collection<Descriptor> getDescriptors(DescriptorRegistryId registryId) {
        return DescriptorRegistry.withReadLock(() -> {
            IDescriptorRegistry descriptorRegistry = REGISTRIES.get(registryId);
            if (null == descriptorRegistry) {
                String msg = String.format("No DescriptorRegistry with key %s has been loaded.", registryId.toString());
                throw new IllegalStateException(msg);
            }
            return descriptorRegistry._getDescriptors();
        });
    }

    public static boolean exists(Type type) {
        return DescriptorRegistry.withReadLock(() -> DescriptorRegistry.getDescriptorRegistry(type)._exists(type));
    }

    public static Collection<Type> getSubtypes(Type supertype) {
        return DescriptorRegistry.withReadLock(() -> Collections.unmodifiableCollection(DescriptorRegistry.getDescriptorRegistry(supertype)._getSubtypes(supertype)));
    }
}

