/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import java.util.Collection;
import java.util.List;

public interface IDescriptorRegistry extends AutoCloseable {

    int HIGHEST_PRECEDENCE = Integer.MIN_VALUE;
    int LOWEST_PRECEDENCE = Integer.MAX_VALUE;
    int DEFAULT_PRECEDENCE = 0;

    DescriptorRegistryId getId();

    Type lookupType(String typeName);

    Type lookupType(Class<?> ciClass);

    Type lookupType(String prefix, String simpleName);

    boolean isLocal();

    // marker for default registries (local or versioned one) - should be ordered
    boolean isDefault();

    default int getOrder() {
        return DEFAULT_PRECEDENCE;
    }

    Collection<Descriptor> _getDescriptors();

    boolean _exists(Type type);

    Descriptor _getDescriptor(Type type);

    Collection<Type> _getSubtypes(Type supertype);

    // register should be internal private method
    void register(Descriptor descriptor);

    // registerSubtype should be internal private method
    void registerSubtype(Type supertype, Type subtype);

    // validate types in this registry (throw exception like booter does or return true/false?)
    void verifyTypes();

    default void close() throws Exception {
        getHooks().forEach(hook -> hook.onClose(this));
        DescriptorRegistry.remove(this.getId());
    }

    void registerHook(DescriptorRegistryHook hook);

    List<DescriptorRegistryHook> getHooks();
}
