/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.semver;

import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.util.Stream;
import com.github.zafarkhaja.semver.util.UnexpectedElementException;
import com.xebialabs.deployit.plugin.api.semver.Lexer;
import java.util.function.Predicate;

public class VersionRange {
    private boolean rightClosed;
    private Version leftVersion;
    private Version rightVersion;
    private boolean leftClosed;

    public static VersionRange withDefaultLexer(String range) {
        return new VersionRange(range);
    }

    public VersionRange(String range) {
        this(new Lexer(), range);
    }

    public VersionRange(Lexer lexer, String range) {
        Stream<Lexer.Token> tokens = lexer.tokenize(range);
        this.leftClosed = tokens.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_CLOSED});
        boolean leftOpen = tokens.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.LEFT_OPEN});
        try {
            if (!this.leftClosed && !leftOpen) {
                this.parseSingleVersionRange(range);
            } else {
                tokens.consume((Stream.ElementType[])new Lexer.Token.Type[]{this.leftClosed ? Lexer.Token.Type.LEFT_CLOSED : Lexer.Token.Type.LEFT_OPEN});
                this.leftVersion = this.extractVersion(tokens, tokenStream -> !tokenStream.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.COMMA}));
                tokens.consume((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.COMMA});
                this.rightVersion = this.extractVersion(tokens, tokenStream -> !tokenStream.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_CLOSED, Lexer.Token.Type.RIGHT_OPEN}));
                this.rightClosed = tokens.positiveLookahead((Stream.ElementType[])new Lexer.Token.Type[]{Lexer.Token.Type.RIGHT_CLOSED});
                tokens.consume((Stream.ElementType[])new Lexer.Token.Type[]{this.rightClosed ? Lexer.Token.Type.RIGHT_CLOSED : Lexer.Token.Type.RIGHT_OPEN});
            }
        }
        catch (UnexpectedCharacterException | UnexpectedElementException | NumberFormatException e) {
            throw this.createIllegalArgumentException(range, (RuntimeException)e);
        }
    }

    private void parseSingleVersionRange(String range) {
        this.leftClosed = true;
        this.rightClosed = true;
        this.rightVersion = this.leftVersion = this.parseVersion(range);
    }

    private IllegalArgumentException createIllegalArgumentException(String range, RuntimeException e) {
        return new IllegalArgumentException(String.format("Invalid range: '%s'.", range), e);
    }

    private Version extractVersion(Stream<Lexer.Token> tokens, Predicate<Stream<Lexer.Token>> predicate) {
        StringBuilder versionBuilder = new StringBuilder();
        while (tokens.lookahead() != null && predicate.test(tokens)) {
            versionBuilder.append(((Lexer.Token)tokens.consume()).getLexeme());
        }
        return this.parseVersion(versionBuilder.toString());
    }

    private Version parseVersion(String version) {
        Version parsedVersion = null;
        String trimmedVersion = version.trim();
        if (!trimmedVersion.isEmpty()) {
            String[] parts = trimmedVersion.split("\\.");
            parsedVersion = parts.length == 1 ? Version.forIntegers((int)Integer.parseInt(parts[0])) : (parts.length == 2 ? Version.forIntegers((int)Integer.parseInt(parts[0]), (int)Integer.parseInt(parts[1])) : Version.valueOf((String)version));
        }
        return parsedVersion;
    }

    public boolean includes(Version version) {
        return !(this.leftVersion != null && this.leftVersion.compareTo(version) >= (this.leftClosed ? 1 : 0) || this.rightVersion != null && this.rightVersion.compareTo(version) < (this.rightClosed ? 0 : 1));
    }
}

