/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.xebialabs.deployit.plugin.api.udm.*;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;


@Metadata(virtual = true, description = "The supertype for infrastructure as code deployeds with output variables.")
public class BaseDeployedInfrastructureAsCode<D extends DeployableArtifact, C extends Container> extends BaseDeployedArtifact<D, C> {

    @Property(description = "Output variables captured in deployed.", required = false)
    private Map<String, String> outputVariables = new HashMap<>();

    @Property(label = "Environment path and name", required=false, category = "Generated Configuration Items", description = "Path to the new environment. If empty, the generated CIs will be added to the target environment. If you specify an environment name, the new environment will be created in the same folder as the target environment. If you specify a folder and an environment name, they will be created in the same folder as the target environment. You can also specify a full path starting with 'Environments/'.")
    private String environmentPath = "";

    @Property(label = "Create dictionary from output variables", category = "Generated Configuration Items", description = "If true, XL Deploy will automatically create a dictionary containing the output variables and add it to the environment.")
    private boolean automaticDictionary = true;

    @Property(label = "Dictionary path and name", required=false, category = "Generated Configuration Items", description = "Path to the dictionary containing the output variables. If empty, the dictionary name will be the name of the template concatenated with -dictionary. If you specify a dictionary name, it will be created in the same folder as the target environment or in the folder specified for the new environment. You can also specify a full path starting with 'Environments/'.")
    private String dictionaryPath = "";

    @Property(label = "Generate CIs from resources", category = "Generated Configuration Items", description = "If true, XL Deploy will automatically create CIs based on resources that are deployed.")
    private boolean generateCIsFromResources = true;

    @Property(label = "Generated CIs", required=false, category = "Generated Configuration Items", description = "Set of infrastructure resources mapped to configuration items.")
    private Set<ConfigurationItem> generatedConfigurationItems = new HashSet<>();

    public Map<String, String> getOutputVariables() {
        return this.outputVariables;
    }

    public void setOutputVariables(Map<String, String> newValue) {
        this.outputVariables = newValue;
    }

    public boolean getAutomaticDictionary() {
        return automaticDictionary;
    }

    public void setAutomaticDictionary(boolean newValue) {
        this.automaticDictionary = newValue;
    }

    public String getDictionaryPath() {
        return this.dictionaryPath;
    }

    public void setDictionaryPath(String newValue){
        this.dictionaryPath = newValue;
    }

    public String getEnvironmentPath(){
        return this.environmentPath;
    }

    public void setEnvironmentPath(String newValue){
        this.environmentPath = newValue;
    }

    public void setGenerateCIsFromResources(boolean newValue) {
        this.generateCIsFromResources = newValue;
    }

    public boolean getGenerateCIsFromResources() {
        return this.generateCIsFromResources;
    }

    public Set<ConfigurationItem> getGeneratedConfigurationItems(){
        return this.generatedConfigurationItems;
    }

    public void setGeneratedConfigurationItems(Set<ConfigurationItem> newValue){
        this.generatedConfigurationItems = newValue;
    }
}
