/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.udm;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.lang.annotation.*;

/**
 * Specifies that this class is a configuration item.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface Metadata {

    /**
     * The description of this configuration item.
     */
    String description() default "Description unavailable";

    /**
     * The label of this configuration item.
     */
    String label() default "";

    /**
     * The root under which to place configuration items of this type in the JCR tree. If {@link ConfigurationItemRoot#NESTED} is specified, configuration items
     * of this type cannot be placed directly under a root.
     */
    ConfigurationItemRoot root() default ConfigurationItemRoot.NESTED;

    /**
     * In case when {@link Metadata#root()} is set to {@link ConfigurationItemRoot#BY_ROOT_NAME} this value is read as desired root for this item.
     */
    String rootName() default "";

    /**
     * Whether or not this is a virtual type, i.e. whether or not CIs of this type can be created.
     */
    boolean virtual() default false;
    
    /**
     * Whether or not this is a versioned type, i.e. whether or not the JCR version history for CIs of this type is kept.
     */
    boolean versioned() default true;

    /**
     * Whether or not the type is inspectable.
     */
    boolean inspectable() default false;

    /**
     * The root in the JCR tree.
     */
    @PublicApiRef
    enum ConfigurationItemRoot {

        APPLICATIONS("Applications"),

        INFRASTRUCTURE("Infrastructure"),

        ENVIRONMENTS("Environments"),

        CONFIGURATION("Configuration"),

        BY_ROOT_NAME("ByRootName"),

        NESTED(null);

        private String rootNodeName;

        ConfigurationItemRoot(String rootNodeName) {
            this.rootNodeName = rootNodeName;
        }

        public String getRootNodeName() {
            return rootNodeName;
        }

    }
}
