/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.flow;

/**
 * Return codes that should be returned from a step during execution.
 */
public enum StepExitCode {
    /** Step was executed successfully. */
    SUCCESS,
    /** The step failed to execute, and should be skipped or retried manually. */
    FAIL,
    /** The step requested the execution to be paused. */
    PAUSE,
    /** Retries the step in a configurable amount of seconds */
    RETRY
}
