/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.credentials

import java.util.function.BiConsumer

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}

import scala.beans.BeanProperty

@Metadata(root = CONFIGURATION, description = "Credentials for SSH Host")
class SshHostCredentials extends HostCredentials {
  @Property(label = "Private Key File", required = false)
  @BeanProperty
  var privateKeyFile: String = _

  @Property(password = true, label = "Passphrase", required = false)
  @BeanProperty
  var passphrase: String = _

  override def applyProperties(consumer: BiConsumer[String, String]): Unit = {
    super.applyProperties(consumer)
    consumer.accept("privateKeyFile", getPrivateKeyFile)
    consumer.accept("passphrase", getPassphrase)
  }
}
