package com.xebialabs.deployit.plugin.api.reflect;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class TypeInitializer {
    public static void init() {
        scanClasses();
    }

    static void scanClasses() {
        Set<Class<? extends ConfigurationItem>> cis = ReflectionsHolder.getSubTypesOf(ConfigurationItem.class);
        for (Class<? extends ConfigurationItem> ci : cis) {
            if (!ci.isInterface()) {
                DescriptorRegistry.register(ci);
            }
        }
    }

}
