package com.xebialabs.deployit.plugin.api.udm;


import java.util.Collections;
import java.util.Set;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Sets.newHashSet;

/**
 * Represents a collection of deployables and resources that can be deployed onto middleware.
 */
@SuppressWarnings("serial")
@Metadata(description = "A package of a certion version of an application, i.e. a grouping of a number of deployable artifact CI's. Contains as its members all the application components that make it up. Is contained by the Application CI of which it supplies a version.")
public class DeploymentPackage extends Version {

    @Property(description = "The set of deployables that are part of this package", asContainment = true)
	private Set<Deployable> deployables = newHashSet();

	public DeploymentPackage() {
		// no op
	}

	public DeploymentPackage(Deployable... deployables) {
        this.deployables = newHashSet(deployables);
    }

    public Set<Deployable> getDeployables() {
		return Collections.unmodifiableSet(deployables);
	}

	public void setDeployables(Set<Deployable> deployables) {
		this.deployables = deployables;
	}

	public void addDeployable(Deployable artifact) {
		deployables.add(checkNotNull(artifact));
	}
}
