/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.GlobalContext;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class PropertyDescriptor {
    private Descriptor declaringDescriptor;
    private String name;
    private Field field;
    private boolean asContainment;
    private String category;
    private String description;
    private String label;
    private boolean password;
    private boolean required;
    private Property.Size size;
    private PropertyKind kind;
    private List<String> enumValues;
    private Class<?> enumClass;
    private Type referencedType;
    private List<PropertyDescriptor> listDescriptors;
    private boolean hidden;
    private boolean inspectionProperty;
    private boolean requiredForInspection;
    private boolean isTransient;

    private PropertyDescriptor(Field field) {
        this.name = field.getName();
        this.field = field;
        field.setAccessible(true);
    }

    private PropertyDescriptor(String name) {
        this.name = name;
        this.field = null;
    }

    static PropertyDescriptor from(Descriptor descriptor, Field field) {
        return PropertyDescriptor.from(descriptor, field, true);
    }

    static PropertyDescriptor from(Descriptor descriptor, Field field, boolean topLevel) {
        Property annotation = field.getAnnotation(Property.class);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field);
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.initMetadata(annotation);
        propertyDescriptor.initType(annotation, topLevel);
        PropertyDescriptor.initInspectionMetadata(field, propertyDescriptor);
        PropertyDescriptor.check(propertyDescriptor);
        return propertyDescriptor;
    }

    static PropertyDescriptor from(Descriptor descriptor, Element propertyElement) {
        String name = SyntheticHelper.getRequiredStringAttribute(propertyElement, "name");
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name);
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.initSynthetic(propertyElement);
        PropertyDescriptor.check(propertyDescriptor);
        return propertyDescriptor;
    }

    private static void check(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.hidden) {
            Preconditions.checkState((boolean)propertyDescriptor.isTransient, (String)"Hidden property %s should be transient", (Object[])new Object[]{propertyDescriptor});
        }
    }

    private static void initInspectionMetadata(Field field, PropertyDescriptor propertyDescriptor) {
        if (field.isAnnotationPresent(InspectionProperty.class)) {
            propertyDescriptor.inspectionProperty = true;
            propertyDescriptor.requiredForInspection = field.getAnnotation(InspectionProperty.class).required();
        }
    }

    private void initMetadata(Property annotation) {
        this.category = annotation.category();
        this.label = PropertyDescriptor.isBlank(annotation.label()) ? PropertyDescriptor.deCamelize(this.name) : annotation.label();
        this.description = PropertyDescriptor.isBlank(annotation.description()) ? this.label : annotation.description();
        this.password = annotation.password();
        this.required = annotation.required();
        this.size = annotation.size();
        this.hidden = annotation.hidden();
        this.isTransient = this.hidden ? true : annotation.isTransient();
    }

    private void initType(Property annotation, boolean topLevel) {
        Class<?> type = this.field.getType();
        if (type == Boolean.TYPE) {
            this.kind = PropertyKind.BOOLEAN;
        } else if (type == Integer.TYPE) {
            this.kind = PropertyKind.INTEGER;
        } else if (type == String.class) {
            this.kind = PropertyKind.STRING;
        } else if (type.isEnum()) {
            this.kind = PropertyKind.ENUM;
            this.initEnumValues(this.field.getType());
        } else if (ConfigurationItem.class.isAssignableFrom(type)) {
            this.kind = PropertyKind.CI;
            this.referencedType = Type.valueOf(type);
            this.asContainment = annotation.asContainment();
        } else if (Set.class.isAssignableFrom(type)) {
            this.initSetType(annotation);
        } else if (Map.class.isAssignableFrom(type)) {
            this.initMapType(annotation);
        } else {
            throw new IllegalArgumentException(String.format("Type of %s not supported as an @Property field, found on %s.%s", type.getName(), this.field.getDeclaringClass().getName(), this.name));
        }
        GlobalContext.register(this, annotation.defaultValue());
    }

    private Object convertValue(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            return null;
        }
        switch (this.kind) {
            case BOOLEAN: {
                return Boolean.parseBoolean(val);
            }
            case INTEGER: {
                return Integer.parseInt(val);
            }
            case STRING: {
                return val;
            }
            case ENUM: {
                for (Enum enumConstant : (Enum[])this.enumClass.getEnumConstants()) {
                    if (!enumConstant.name().equalsIgnoreCase(val)) continue;
                    return enumConstant;
                }
                throw new IllegalArgumentException("Value " + val + " not a member of enum " + this.field.getType());
            }
        }
        throw new IllegalArgumentException("Property " + this.name + " of kind " + (Object)((Object)this.kind) + " cannot be converted from a string value");
    }

    private void initSetType(Property annotation) {
        Class<?> setType = this.getGenericType(Set.class, 1, 0);
        if (setType == String.class) {
            this.kind = PropertyKind.SET_OF_STRING;
        } else if (ConfigurationItem.class.isAssignableFrom(setType)) {
            this.kind = PropertyKind.SET_OF_CI;
            this.referencedType = Type.valueOf(setType);
            this.asContainment = annotation.asContainment();
        } else {
            throw new IllegalStateException(String.format("Unsupported Set type encountered for [%s]. Only support String and ConfigurationItem", this.name));
        }
    }

    private void initMapType(Property annotation) {
        Preconditions.checkArgument((this.getGenericType(Map.class, 2, 0) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name});
        Preconditions.checkArgument((this.getGenericType(Map.class, 2, 1) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name});
        this.kind = PropertyKind.MAP_STRING_STRING;
    }

    private Class<?> getGenericType(Class<?> collectionClass, int nrExpectedTypes, int indexOfType) {
        java.lang.reflect.Type genericType = this.field.getGenericType();
        Preconditions.checkArgument((boolean)(genericType instanceof ParameterizedType), (String)"The field %s.%s is a %s but it isn't a generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, collectionClass, genericType});
        Object[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
        Preconditions.checkArgument((actualTypeArguments.length == nrExpectedTypes ? 1 : 0) != 0, (String)"The field %s is a %s.%s but it doesn't have the right generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, collectionClass, actualTypeArguments});
        Preconditions.checkArgument((boolean)(actualTypeArguments[indexOfType] instanceof Class), (String)"The field %s.%s is a %s but it is not a concrete subclass (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, collectionClass, Arrays.toString(actualTypeArguments)});
        return (Class)actualTypeArguments[indexOfType];
    }

    private void initEnumValues(Class<?> enumClass) {
        this.enumValues = Lists.newArrayList();
        this.enumClass = enumClass;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            this.enumValues.add(enumValue.name());
        }
    }

    void overrideWith(PropertyDescriptor superDescriptor) {
        Preconditions.checkArgument((superDescriptor.getKind() == this.getKind() ? 1 : 0) != 0, (String)"Type '%s' attempts to overrides property '%s' declared in type '%s', but kind attribute does not match. Derived kind: '%s'. Super kind: '%s'.", (Object[])new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), superDescriptor.getDeclaringDescriptor().getType(), this.getKind(), superDescriptor.getKind()});
        this.checkOverrideArgument(superDescriptor.isAsContainment() == this.isAsContainment(), "asContainment", superDescriptor.isAsContainment(), superDescriptor);
        this.checkOverrideArgument(superDescriptor.getReferencedType() == this.getReferencedType(), "referenceType", superDescriptor.getReferencedType(), superDescriptor);
        this.checkOverrideArgument(superDescriptor.enumClass == this.enumClass, "enumClass", superDescriptor.enumClass, superDescriptor);
        this.checkOverrideArgument(superDescriptor.isPassword() == this.isPassword(), "password", superDescriptor.isPassword(), superDescriptor);
        if (superDescriptor.isRequired()) {
            this.checkOverrideArgument(this.isRequired(), "required", superDescriptor.isRequired(), superDescriptor);
        }
        this.field = superDescriptor.field;
    }

    private void checkOverrideArgument(boolean condition, String attribute, Object expectedValue, PropertyDescriptor superDescriptor) {
        String attributeErrorTemplate = "Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.";
        Preconditions.checkArgument((boolean)condition, (String)"Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.", (Object[])new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), superDescriptor.getDeclaringDescriptor().getType(), attribute, expectedValue});
    }

    private void initSynthetic(Element propertyElement) {
        this.kind = PropertyKind.valueOf(SyntheticHelper.getOptionalStringAttribute(propertyElement, "kind", PropertyKind.STRING.name()).toUpperCase());
        this.category = SyntheticHelper.getOptionalStringAttribute(propertyElement, "category", "Common");
        this.label = SyntheticHelper.getOptionalStringAttribute(propertyElement, "label", PropertyDescriptor.deCamelize(this.name));
        this.description = SyntheticHelper.getOptionalStringAttribute(propertyElement, "description", this.label);
        this.required = SyntheticHelper.getOptionalBooleanAttribute(propertyElement, "required", true);
        this.password = SyntheticHelper.getOptionalBooleanAttribute(propertyElement, "password", false);
        this.asContainment = SyntheticHelper.getOptionalBooleanAttribute(propertyElement, "as-containment", false);
        this.size = Property.Size.valueOf(SyntheticHelper.getOptionalStringAttribute(propertyElement, "size", Property.Size.MEDIUM.name()).toUpperCase());
        String defaultValueAttr = SyntheticHelper.getOptionalStringAttribute(propertyElement, "default", "");
        this.hidden = SyntheticHelper.getOptionalBooleanAttribute(propertyElement, "hidden", false);
        this.isTransient = this.hidden ? true : SyntheticHelper.getOptionalBooleanAttribute(propertyElement, "transient", false);
        if (this.kind == PropertyKind.ENUM) {
            String enumClassAttributeValue = SyntheticHelper.getRequiredStringAttribute(propertyElement, "enum-class", "for property " + this.name + " of kind " + (Object)((Object)this.kind));
            try {
                this.enumClass = Class.forName(enumClassAttributeValue);
                if (!this.enumClass.isEnum()) {
                    throw new IllegalArgumentException("enum-class supplied for property " + this.name + " of kind " + (Object)((Object)this.kind) + " is not an enum: " + enumClassAttributeValue);
                }
                this.initEnumValues(this.enumClass);
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException("Unknown enum-class supplied for property " + this.name + " of kind " + (Object)((Object)this.kind) + ": " + enumClassAttributeValue, exc);
            }
        }
        if (this.kind == PropertyKind.CI || this.kind == PropertyKind.SET_OF_CI) {
            this.referencedType = Type.valueOf(SyntheticHelper.getRequiredStringAttribute(propertyElement, "referenced-type", "for property " + this.name + " of kind " + (Object)((Object)this.kind)));
        }
        GlobalContext.register(this, defaultValueAttr);
    }

    static PropertyDescriptor generateDeployableFrom(Descriptor descriptor, PropertyDescriptor deployedPropertyDescriptor) {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(deployedPropertyDescriptor.getName());
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.generateDeployable(deployedPropertyDescriptor);
        return propertyDescriptor;
    }

    private void generateDeployable(PropertyDescriptor deployedPropertyDescriptor) {
        this.kind = deployedPropertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : deployedPropertyDescriptor.getKind();
        this.category = deployedPropertyDescriptor.getCategory();
        this.label = deployedPropertyDescriptor.getLabel();
        this.description = deployedPropertyDescriptor.getDescription();
        this.required = false;
        this.password = deployedPropertyDescriptor.isPassword();
        this.size = deployedPropertyDescriptor.getSize();
        this.field = null;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAsContainment() {
        return this.asContainment;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Property.Size getSize() {
        return this.size;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public Descriptor getDeclaringDescriptor() {
        return this.declaringDescriptor;
    }

    public List<PropertyDescriptor> getListDescriptors() {
        return this.listDescriptors;
    }

    public Type getReferencedType() {
        return this.referencedType;
    }

    public Object getDefaultValue() {
        return this.convertValue(GlobalContext.lookup(this));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Object get(ConfigurationItem item) {
        if (this.field != null) {
            try {
                return this.field.get(item);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot get field " + this.field, e);
            }
        }
        return item.getSyntheticProperty(this.name);
    }

    public void set(ConfigurationItem item, Object value) {
        if (this.kind.isSimple() && value instanceof String) {
            value = this.convertValue((String)value);
        } else if (value == null) {
            value = this.getDefaultValue();
        }
        try {
            if (this.field != null) {
                if (value == null) {
                    return;
                }
                this.field.set(item, value);
            } else {
                item.putSyntheticProperty(this.name, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot set field " + this.field, e);
        }
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.areEqual(item, other, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem item, ConfigurationItem other, Set<String> itemsBeingCompared) {
        Object left = this.get(item);
        Object right = this.get(other);
        return this.areValuesEqual(left, right, itemsBeingCompared);
    }

    private boolean areValuesEqual(Object itemValue, Object otherValue, Set<String> itemsBeingCompared) {
        if (itemValue == null) {
            return otherValue == null;
        }
        switch (this.kind) {
            case SET_OF_STRING: {
                return Sets.difference((Set)((Set)itemValue), (Set)((Set)otherValue)).isEmpty();
            }
            case SET_OF_CI: {
                Function<ConfigurationItem, String> f = new Function<ConfigurationItem, String>(){

                    public String apply(ConfigurationItem from) {
                        return from.getName();
                    }
                };
                Iterable cis = Iterables.concat((Iterable)((Set)itemValue), (Iterable)((Set)otherValue));
                ImmutableListMultimap index = Multimaps.index((Iterable)cis, (Function)f);
                for (String key : index.keySet()) {
                    Descriptor descriptor;
                    Collection cisToCompare = index.get((Object)key);
                    if (cisToCompare.size() != 2) {
                        return false;
                    }
                    Iterator itemIterator = cisToCompare.iterator();
                    ConfigurationItem lhs = (ConfigurationItem)itemIterator.next();
                    ConfigurationItem rhs = (ConfigurationItem)itemIterator.next();
                    if (lhs.getType().equals(rhs.getType()) && (descriptor = DescriptorRegistry.getDescriptor(lhs.getType())).areEqual(lhs, rhs, itemsBeingCompared)) continue;
                    return false;
                }
                return true;
            }
            case CI: {
                ConfigurationItem itemValueAsCi = (ConfigurationItem)itemValue;
                ConfigurationItem otherValueAsCi = (ConfigurationItem)otherValue;
                if (otherValueAsCi != null && itemValueAsCi.getName().equals(otherValueAsCi.getName())) {
                    Descriptor descriptor = DescriptorRegistry.getDescriptor(itemValueAsCi.getType());
                    return descriptor.areEqual(itemValueAsCi, otherValueAsCi, itemsBeingCompared);
                }
                return false;
            }
            case MAP_STRING_STRING: {
                Map left = (Map)itemValue;
                Map right = (Map)otherValue;
                return Maps.difference((Map)left, (Map)right).areEqual();
            }
        }
        return itemValue.equals(otherValue);
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static String deCamelize(String fieldName) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (Character.isUpperCase(c)) {
                buf.append(" ");
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public boolean isInspectionProperty() {
        return this.inspectionProperty;
    }

    public boolean isRequiredForInspection() {
        return this.requiredForInspection;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String toString() {
        return this.declaringDescriptor.getType() + "." + this.name;
    }
}

