/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import java.util.ArrayList;

public class DeployableGenerator {
    public static void init() {
        DeployableGenerator.generateDeployables();
    }

    static void generateDeployables() {
        ArrayList generatedDeployableDescriptors = Lists.newArrayList();
        for (Descriptor descriptor : Lists.newArrayList(DescriptorRegistry.getDescriptors())) {
            if (!descriptor.shouldGenerateDeployableType()) continue;
            Descriptor generated = Descriptor.from(descriptor);
            generatedDeployableDescriptors.add(generated);
            DescriptorRegistry.register(generated);
        }
        for (Descriptor d : generatedDeployableDescriptors) {
            d.initHierarchy();
        }
    }
}

