package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface Descriptor {
    Type getType();

    Class<?> getClazz();

    String getDescription();

    Metadata.ConfigurationItemRoot getRoot();

    Collection<PropertyDescriptor> getPropertyDescriptors();

    PropertyDescriptor getPropertyDescriptor(String name);

    MethodDescriptor getControlTask(String name);

    Collection<MethodDescriptor> getControlTasks();

    boolean isAssignableTo(Class<?> clazz);

    boolean isAssignableTo(Type type);

    List<Type> getSuperClasses();

    Set<Type> getInterfaces();

    boolean isVirtual();

    boolean areEqual(ConfigurationItem item, ConfigurationItem other);

    <T extends ConfigurationItem> T newInstance();

    @Override
    String toString();

    Type getDeployableType();

    Type getContainerType();

    List<ValidationMessage> validate(ConfigurationItem ci);

    boolean isInspectable();
}
