package com.xebialabs.deployit.plugin.api.udm;


import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "A version of an application .")
public abstract class Version extends BaseConfigurationItem {

    @Property(description = "The application this version belongs to.", asContainment = true)
    private Application application;

    /**
     * By convention, the version of a Version is the last part of the id (which is in effect the same as the getName() returns.
     * @return The last part of the id
     * @see #getName()
     */
    public String getVersion() {
        return getName();
    }

    public Application getApplication() {
        return application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public abstract Set<Deployable> getDeployables();
}
