/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.jee.artifact.Ear;
import com.xebialabs.deployit.plugin.jee.artifact.EjbJar;
import com.xebialabs.deployit.plugin.jee.artifact.War;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TestUtils {
    public static <T> T newInstance(String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)type);
        if (descriptor == null) {
            throw new RuntimeException("Cannot instantiate unknown type");
        }
        return (T)descriptor.newInstance();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return TestUtils.newInstance(Type.valueOf(clazz).toString());
    }

    public static String id(String ... names) {
        return Joiner.on((char)'/').join((Object[])names);
    }

    public static DeploymentPackage createDeploymentPackage(Deployable ... deployables) {
        return TestUtils.createDeploymentPackage("1.0", deployables);
    }

    public static DeploymentPackage createDeploymentPackage(String version, Deployable ... deployables) {
        Application app = TestUtils.newInstance(Application.class);
        app.setId(TestUtils.id("Applications", "Test"));
        DeploymentPackage pkg = TestUtils.newInstance(DeploymentPackage.class);
        pkg.setId(TestUtils.id(pkg.getId(), version));
        pkg.setApplication(app);
        for (Deployable deployable : deployables) {
            deployable.setId(TestUtils.id(app.getId(), deployable.getId()));
            pkg.addDeployable(deployable);
        }
        return pkg;
    }

    public static Environment createEnvironment(Container ... containers) {
        Environment env = TestUtils.newInstance(Environment.class);
        env.setId(TestUtils.id("Environments", "JUnit"));
        HashSet containerSet = Sets.newHashSet();
        containerSet.addAll(Arrays.asList(containers));
        env.setMembers((Set)containerSet);
        return env;
    }

    public static DeployedApplication createDeployedApplication(DeploymentPackage pkg, Environment env) {
        DeployedApplication deployedApp = TestUtils.newInstance(DeployedApplication.class);
        deployedApp.setVersion((Version)pkg);
        deployedApp.setEnvironment(env);
        return deployedApp;
    }

    public static Ear newEar(String name, String version, String classpathResource, File workingFolder) throws IOException {
        return TestUtils.newEar(name, version, classpathResource, "jee.Ear", workingFolder);
    }

    public static Ear newEar(String name, String version, String classpathResource, String type, File workingFolder) throws IOException {
        return TestUtils.createArtifact(name, version, classpathResource, type, workingFolder, Ear.class);
    }

    public static <T extends SourceArtifact> T createArtifact(String name, String version, String classpathResource, String type, File workingFolder, Class<T> clazz) throws IOException {
        SourceArtifact artifact = (SourceArtifact)TestUtils.newInstance(type);
        artifact.setId(TestUtils.id("Applications", "Test", version, name));
        File artifactFile = new File(workingFolder, artifact.getName());
        artifactFile.createNewFile();
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)artifactURL), (File)artifactFile);
        artifact.setFile(LocalFile.valueOf((File)artifactFile));
        return (T)artifact;
    }

    public static War newWar(String name, String version, String classpathResource, String type, File workingFolder) throws IOException {
        return TestUtils.createArtifact(name, version, classpathResource, type, workingFolder, War.class);
    }

    public static EjbJar newEjbJar(String name, String version, String classpathResource, String type, File workingFolder) throws IOException {
        return TestUtils.createArtifact(name, version, classpathResource, type, workingFolder, EjbJar.class);
    }
}

