package com.xebialabs.deployit.test.support;

import static com.google.common.collect.Maps.newHashMap;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;

public class LoggingExecutionContext implements ExecutionContext {

	private Map<String, Object> attributes;

	private final Logger logger;

	public LoggingExecutionContext(Class<?> clazz) {
		this.attributes = newHashMap();
		this.logger = LoggerFactory.getLogger(clazz);
	}

	public void logOutput(String output) {
		logger.info(output);
	}

	public void logError(String error) {
		logger.error(error);
	}

	public void logError(String error, Throwable t) {
		logger.error(error, t);
	}

	public Object getAttribute(String name) {
		return attributes.get(name);
	}

	public void setAttribute(String name, Object object) {
		attributes.put(name, object);
	}

	public void destroy() {
		for (Object attr : attributes.values()) {
			if (attr instanceof ExecutionContextListener) {
				((ExecutionContextListener) (attr)).contextDestroyed();
			}
		}
	}

}
