/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class CapturingExecutionContext<C extends ExecutionContext>
implements ExecutionContext {
    protected C originalContext;
    protected List<String> capturedOutput = Lists.newArrayList();
    protected List<String> capturedError = Lists.newArrayList();

    public CapturingExecutionContext(C originalContext) {
        this.originalContext = originalContext;
    }

    public void logOutput(String output) {
        this.originalContext.logOutput(output);
        this.capturedOutput.add(output);
    }

    public void logError(String error) {
        this.originalContext.logError(error);
        this.capturedError.add(error);
    }

    public void logError(String error, Throwable t) {
        this.originalContext.logError(error, t);
        this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    public Object getAttribute(String name) {
        return this.originalContext.getAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.originalContext.setAttribute(name, object);
    }

    public List<String> getCapturedOutput() {
        return this.capturedOutput;
    }

    public List<String> getCapturedError() {
        return this.capturedError;
    }
}

