package com.xebialabs.deployit.test.support;

import static com.google.common.collect.Lists.newArrayList;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;

public class CapturingExecutionContext<C extends ExecutionContext> implements ExecutionContext {

	protected C originalContext;
	protected List<String> capturedOutput = newArrayList();
	protected List<String> capturedError = newArrayList();

	public CapturingExecutionContext(C originalContext) {
    	this.originalContext = originalContext;
    }

    @Override
    public void logOutput(String output) {
    	this.originalContext.logOutput(output);
    	this.capturedOutput.add(output);
    }

    @Override
    public void logError(String error) {
    	this.originalContext.logError(error);
    	this.capturedError.add(error);
    }

    @Override
    public void logError(String error, Throwable t) {
    	this.originalContext.logError(error, t);
    	this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    @Override
    public Object getAttribute(String name) {
    	return originalContext.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object object) {
    	originalContext.setAttribute(name, object);
    }

    public List<String> getCapturedOutput() {
        return capturedOutput;
    }

    public List<String> getCapturedError() {
        return capturedError;
    }

}