/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.jee.artifact.Ear;
import com.xebialabs.deployit.plugin.jee.artifact.EjbJar;
import com.xebialabs.deployit.plugin.jee.artifact.War;
import com.xebialabs.deployit.test.deployment.DeltaSpecifications;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TestUtils {
    public static <T> T newInstance(String string) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)string);
        if (descriptor == null) {
            throw new RuntimeException("Cannot instantiate unknown type");
        }
        return (T)descriptor.newInstance();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return TestUtils.newInstance(Type.valueOf(clazz).toString());
    }

    public static String id(String ... stringArray) {
        return Joiner.on((char)'/').join((Object[])stringArray);
    }

    public static DeploymentPackage createDeploymentPackage(Deployable ... deployableArray) {
        return TestUtils.createDeploymentPackage("1.0", deployableArray);
    }

    public static DeploymentPackage createDeploymentPackage(String string, Deployable ... deployableArray) {
        Application application = TestUtils.newInstance(Application.class);
        application.setId(TestUtils.id("Applications", "Test"));
        DeploymentPackage deploymentPackage = TestUtils.newInstance(DeploymentPackage.class);
        deploymentPackage.setId(TestUtils.id(deploymentPackage.getId(), string));
        deploymentPackage.setApplication(application);
        for (Deployable deployable : deployableArray) {
            deployable.setId(TestUtils.id(application.getId(), deployable.getId()));
            deploymentPackage.addDeployable(deployable);
        }
        return deploymentPackage;
    }

    public static Environment createEnvironment(Container ... containerArray) {
        Environment environment = TestUtils.newInstance(Environment.class);
        environment.setId(TestUtils.id("Environments", "JUnit"));
        HashSet hashSet = Sets.newHashSet();
        hashSet.addAll(Arrays.asList(containerArray));
        environment.setMembers((Set)hashSet);
        return environment;
    }

    public static DeployedApplication createDeployedApplication(DeploymentPackage deploymentPackage, Environment environment) {
        return DeltaSpecifications.createDeployedApplication((Version)deploymentPackage, environment);
    }

    public static Ear newEar(String string, String string2, String string3, File file) throws IOException {
        return TestUtils.newEar(string, string2, string3, "jee.Ear", file);
    }

    public static Ear newEar(String string, String string2, String string3, String string4, File file) throws IOException {
        return (Ear)TestUtils.createArtifact(string, string2, string3, string4, file);
    }

    public static <T extends SourceArtifact> T createArtifact(String string, String string2, String string3, String string4, File file) throws IOException {
        SourceArtifact sourceArtifact = (SourceArtifact)TestUtils.newInstance(string4);
        sourceArtifact.setId(TestUtils.id("Applications", "Test", string2, string));
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string3);
        File file2 = new File(file, sourceArtifact.getName());
        file2.createNewFile();
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)uRL), (File)file2);
        sourceArtifact.setFile(LocalFile.valueOf((File)file2));
        return (T)sourceArtifact;
    }

    public static <T extends SourceArtifact> T createArtifactWithoutCopy(String string, String string2, String string3, String string4, File file) throws URISyntaxException {
        SourceArtifact sourceArtifact = (SourceArtifact)TestUtils.newInstance(string4);
        sourceArtifact.setId(TestUtils.id("Applications", "Test", string2, string));
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string3);
        sourceArtifact.setFile(LocalFile.valueOf((File)new File(uRL.toURI().getPath())));
        return (T)sourceArtifact;
    }

    public static War newWar(String string, String string2, String string3, String string4, File file) throws IOException {
        return (War)TestUtils.createArtifact(string, string2, string3, string4, file);
    }

    public static EjbJar newEjbJar(String string, String string2, String string3, String string4, File file) throws IOException {
        return (EjbJar)TestUtils.createArtifact(string, string2, string3, string4, file);
    }
}

