package com.xebialabs.deployit.test.deployment;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;
import java.util.Map;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class InMemoryRepository implements ReadOnlyRepository {
	private Map<String, ConfigurationItem> store = Maps.newHashMap();

	@SuppressWarnings("unchecked")
	@Override
	public <T extends ConfigurationItem> T read(final String id) {
		return (T) store.get(id);
	}

	@Override
	public <T extends ConfigurationItem> List<T> search(Type type, final String parent) {
		return newArrayList(Iterables.<T>filter(this.<T>search(type), new Predicate<ConfigurationItem>() {
			public boolean apply(ConfigurationItem input) {
				return input.getId().startsWith(parent);
			}
		}));
	}

	@SuppressWarnings("unchecked")
    @Override
	public <T extends ConfigurationItem> List<T> search(Type type) {
		List<T> entities = newArrayList();
		for (ConfigurationItem configurationItem : store.values()) {
			if (configurationItem.getType().equals(type)) {
				entities.add((T) configurationItem);
			}
		}
		return entities;
	}

	public <T extends ConfigurationItem> void create(final T... entities) {
		checkThatEntitiesDoNotExist(entities);
		storeEntities(entities);
	}

	private void checkThatEntitiesDoNotExist(final ConfigurationItem[] entities) {
		for (ConfigurationItem entity : entities) {
			if (store.containsKey(entity.getId())) {
				throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
			}
		}
	}

	private void storeEntities(final ConfigurationItem[] entities) {
		for (ConfigurationItem entity : entities) {
			store.put(entity.getId(), entity);
		}
	}

	public void delete(final String... ids) {
		for(String id: ids) {
			store.remove(id);
		}
	}
}
