/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.deployment.planner.DeploymentPlannerFactory;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.test.deployment.InMemoryRepository;
import com.xebialabs.deployit.test.deployment.SimpleReplacer;
import com.xebialabs.deployit.test.support.LoggingDeploymentExecutionContext;
import com.xebialabs.deployit.test.support.LoggingExecutionContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeployitTester {
    private final DeploymentPlanner planner;
    private final Inspector inspector;
    private final InMemoryRepository repository;

    public static DeployitTester build() {
        DeploymentPlannerFactory deploymentPlannerFactory = new DeploymentPlannerFactory();
        InMemoryRepository inMemoryRepository = new InMemoryRepository();
        return new DeployitTester(deploymentPlannerFactory.planner((ReadOnlyRepository)inMemoryRepository), new Inspector(), inMemoryRepository);
    }

    private DeployitTester(DeploymentPlanner deploymentPlanner, Inspector inspector, InMemoryRepository inMemoryRepository) {
        this.planner = deploymentPlanner;
        this.inspector = inspector;
        this.repository = inMemoryRepository;
    }

    public Plan resolvePlan(DeltaSpecification deltaSpecification) {
        return this.planner.plan(deltaSpecification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItem> inspect(ConfigurationItem configurationItem) {
        LoggingExecutionContext loggingExecutionContext = new LoggingExecutionContext(DeployitTester.class);
        try {
            List<ConfigurationItem> list = this.inspect(configurationItem, loggingExecutionContext);
            return list;
        }
        finally {
            loggingExecutionContext.destroy();
        }
    }

    public List<ConfigurationItem> inspect(ConfigurationItem configurationItem, ExecutionContext executionContext) {
        return this.inspector.inspect(configurationItem, executionContext);
    }

    public Deployed generateDeployed(Deployable deployable, Container container, Type type) {
        return this.generateDeployed(deployable, container, type, null);
    }

    public Deployed generateDeployed(Deployable deployable, Container container, Type type, Map<String, String> map) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        Deployed deployed = (Deployed)descriptor.newInstance();
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        deployed.setId(container.getId() + "/" + this.substringAfterLastSlash(deployable.getId()));
        Descriptor descriptor2 = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            String string = propertyDescriptor.getName();
            PropertyDescriptor propertyDescriptor2 = descriptor2.getPropertyDescriptor(string);
            if (propertyDescriptor2 == null) continue;
            if (propertyDescriptor.getName().equals("placeholders")) {
                propertyDescriptor.set((ConfigurationItem)deployed, (Object)Maps.newHashMap());
                continue;
            }
            propertyDescriptor.set((ConfigurationItem)deployed, propertyDescriptor2.get((ConfigurationItem)deployable));
        }
        if (deployed instanceof DerivedArtifact) {
            DerivedArtifact derivedArtifact = (DerivedArtifact)deployed;
            if (map != null) {
                derivedArtifact.setPlaceholders(map);
            }
            derivedArtifact.initFile((PlaceholderReplacer)new SimpleReplacer());
        }
        return deployed;
    }

    private String substringAfterLastSlash(String string) {
        int n = string.lastIndexOf(47);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result executePlan(Plan plan) {
        LoggingDeploymentExecutionContext loggingDeploymentExecutionContext = new LoggingDeploymentExecutionContext(this.getClass());
        try {
            Step.Result result = this.executePlan(plan, loggingDeploymentExecutionContext);
            return result;
        }
        finally {
            loggingDeploymentExecutionContext.destroy();
        }
    }

    public Step.Result executePlan(Plan plan, DeploymentExecutionContext deploymentExecutionContext) {
        Step.Result result = Step.Result.Warn;
        List list = plan.getSteps();
        try {
            DeploymentStep deploymentStep;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (result = (deploymentStep = (DeploymentStep)iterator.next()).execute((ExecutionContext)deploymentExecutionContext)) != Step.Result.Fail) {
            }
            return result;
        }
        catch (Exception exception) {
            throw new DeployitTesterException(exception);
        }
    }

    public InMemoryRepository getRepository() {
        return this.repository;
    }

    public static class DeployitTesterException
    extends RuntimeException {
        DeployitTesterException(String string, Object ... objectArray) {
            super(String.format(string, objectArray));
        }

        DeployitTesterException(Exception exception) {
            super(exception);
        }
    }
}

