/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InMemoryRepository
implements ReadOnlyRepository {
    private Map<String, ConfigurationItem> store = Maps.newHashMap();

    public <T extends ConfigurationItem> T read(String string) {
        return (T)this.store.get(string);
    }

    public <T extends ConfigurationItem> List<T> search(Type type, final String string) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.search(type), (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem configurationItem) {
                return configurationItem.getId().startsWith(string);
            }
        }));
    }

    public <T extends ConfigurationItem> List<T> search(Type type) {
        ArrayList arrayList = Lists.newArrayList();
        for (ConfigurationItem configurationItem : this.store.values()) {
            if (!configurationItem.getType().equals((Object)type)) continue;
            arrayList.add(configurationItem);
        }
        return arrayList;
    }

    public <T extends ConfigurationItem> void create(T ... TArray) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])TArray);
        this.storeEntities((ConfigurationItem[])TArray);
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] configurationItemArray) {
        for (ConfigurationItem configurationItem : configurationItemArray) {
            if (!this.store.containsKey(configurationItem.getId())) continue;
            throw new IllegalStateException("Entity " + configurationItem.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] configurationItemArray) {
        for (ConfigurationItem configurationItem : configurationItemArray) {
            this.store.put(configurationItem.getId(), configurationItem);
        }
    }

    public void delete(String ... stringArray) {
        for (String string : stringArray) {
            this.store.remove(string);
        }
    }
}

