/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "A WebSphere Application Server cell. Is a member of Host on which the deployment manager runs.", expandable = true)
public class WasCell extends BaseConfigurationItem {

	private static final String CONFIG_DIR_NAME = "config";

	private static final String PLUGIN_FILENAME = "plugin-cfg.xml";

	@ConfigurationItemProperty
	private Host host;

	@ConfigurationItemProperty(required = true, label = "WebSphere name", description = "Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
	private String name;

	@ConfigurationItemProperty(required = false, label = "Administrative username", description = "Username which is used to login to the WebSphere Cell.")
	private String username;

	@ConfigurationItemProperty(required = false, label = "Administrative password", description = "Password which is used to login to the WebSphere Cell.", password = true)
	private String password;

	@ConfigurationItemProperty(required = true, label = "WAS deployment manager profile path", description = "Path of the WebSphere deployment manager profile.")
	private String wasHome;

	@ConfigurationItemProperty(required = true, label = "WAS version", description = "Version of WebSphere Application Server.")
	private WasVersion version;

	public String getWsadminPath() {
		String fileSep = host.getOperatingSystemFamily().getFileSeparator();
		return getWasHome() + fileSep + "bin" + fileSep + "wsadmin" + host.getOperatingSystemFamily().getScriptExtension();
	}

	public String getConfigDirPath() {
		String fileSep = host.getOperatingSystemFamily().getFileSeparator();
		return getWasHome() + fileSep + CONFIG_DIR_NAME;
	}

	public String getPluginFilePath() {
		String fileSep = host.getOperatingSystemFamily().getFileSeparator();
		return getConfigDirPath() + fileSep + "cells" + fileSep + WasCell.PLUGIN_FILENAME;
	}

	public HostSession connectToAdminHost() {
		return host.getHostSession();
	}

	public int executeWsadminJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath, String... args) {
		List<String> cmd = new ArrayList<String>();
		cmd.add(getWsadminPath());
		if (StringUtils.isNotBlank(getUsername())) {
			cmd.add("-user");
			cmd.add(getUsername());
			if (!StringUtils.isEmpty(getPassword())) {
				cmd.add("-password");
				cmd.add(getPassword());
			}
		}
		cmd.add("-lang");
		cmd.add("jython");
		cmd.add("-f");
		cmd.add(scriptPath);
		for (String arg : args) {
			cmd.add(arg);
		}
		String[] cmdArray = (String[]) cmd.toArray(new String[cmd.size()]);

		return s.execute(handler, cmdArray);
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getWasHome() {
		return wasHome;
	}

	public void setWasHome(String wasHome) {
		this.wasHome = wasHome;
	}

	public WasVersion getVersion() {
		return version;
	}

	public void setVersion(WasVersion version) {
		this.version = version;
	}

}
