/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.mapper.StaticContentToApacheHttpdServerMapper;
import com.xebialabs.deployit.plugin.apache.httpd.step.CreateApacheHttpdVirtualHostStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.DestroyApacheHttpdVirtualHostStep;
import com.xebialabs.deployit.plugin.apache.httpd.step.RestartApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.mapper.EarToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WarToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasDataSourceToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueConnectionFactoryToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqQueueToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicConnectionFactoryToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.mapper.WasWmqTopicToWasClusterMapper;
import com.xebialabs.deployit.plugin.was.runbook.WasClusterRunBook;
import com.xebialabs.deployit.plugin.was.runbook.WasRunBookBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasDeploymentRunBook
extends WasRunBookBase<Deployment>
implements RunBook {
    public WasDeploymentRunBook() {
        super(Deployment.class);
    }

    @Override
    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        EarToWasClusterMapper earMapper = new EarToWasClusterMapper(change);
        WarToWasClusterMapper warMapper = new WarToWasClusterMapper(change);
        StaticContentToApacheHttpdServerMapper staticContentMapper = new StaticContentToApacheHttpdServerMapper(change);
        WasDataSourceToWasClusterMapper dsMapper = new WasDataSourceToWasClusterMapper(change);
        WasWmqQueueToWasClusterMapper qMapper = new WasWmqQueueToWasClusterMapper(change);
        WasWmqQueueConnectionFactoryToWasClusterMapper qcfMapper = new WasWmqQueueConnectionFactoryToWasClusterMapper(change);
        WasWmqTopicToWasClusterMapper tMapper = new WasWmqTopicToWasClusterMapper(change);
        WasWmqTopicConnectionFactoryToWasClusterMapper tcfMapper = new WasWmqTopicConnectionFactoryToWasClusterMapper(change);
        if (this.isWasDeployment(earMapper, warMapper, dsMapper, qMapper, qcfMapper, tMapper, tcfMapper)) {
            return;
        }
        HashMap<ApacheHttpdServer, Set<String>> virtualHostsPerWebServerToDestroy = new HashMap<ApacheHttpdServer, Set<String>>();
        earMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToDestroy);
        earMapper.generateDeletionSteps(steps);
        warMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToDestroy);
        warMapper.generateDeletionSteps(steps);
        tMapper.generateDeletionSteps(steps);
        tcfMapper.generateDeletionSteps(steps);
        qMapper.generateDeletionSteps(steps);
        qcfMapper.generateDeletionSteps(steps);
        dsMapper.generateDeletionSteps(steps);
        if (change.isModification()) {
            WasClusterRunBook wasClusterRunBook = new WasClusterRunBook();
            Set<Change<WasCluster>> clusterChanges = this.findClusterChangesForDeploymentChange(change, changePlan);
            for (Change<WasCluster> eachClusterChange : clusterChanges) {
                wasClusterRunBook.getStepsForModifiedCluster(steps, (WasCluster)((Object)eachClusterChange.getOldRevision()), (WasCluster)((Object)eachClusterChange.getNewRevision()));
            }
        }
        HashMap<ApacheHttpdServer, Set<String>> virtualHostsPerWebServerToCreate = new HashMap<ApacheHttpdServer, Set<String>>();
        dsMapper.generateAdditionSteps(steps);
        qcfMapper.generateAdditionSteps(steps);
        qMapper.generateAdditionSteps(steps);
        tcfMapper.generateAdditionSteps(steps);
        tMapper.generateAdditionSteps(steps);
        warMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        warMapper.generateAdditionSteps(steps);
        earMapper.setVirtualHostsPerWebServerCollector(virtualHostsPerWebServerToCreate);
        earMapper.generateAdditionSteps(steps);
        staticContentMapper.generateDeletionSteps(steps);
        this.destroyApacheVirtualHosts(virtualHostsPerWebServerToDestroy, steps);
        this.restartApacheWebServers(virtualHostsPerWebServerToDestroy, steps);
        this.createApacheVirtualHosts(virtualHostsPerWebServerToCreate, steps);
        staticContentMapper.generateAdditionSteps(steps);
        this.restartApacheWebServers(virtualHostsPerWebServerToCreate, steps);
    }

    private boolean isWasDeployment(EarToWasClusterMapper earMapper, WarToWasClusterMapper warMapper, WasDataSourceToWasClusterMapper dsMapper, WasWmqQueueToWasClusterMapper qMapper, WasWmqQueueConnectionFactoryToWasClusterMapper qcfMapper, WasWmqTopicToWasClusterMapper tMapper, WasWmqTopicConnectionFactoryToWasClusterMapper tcfMapper) {
        HashSet affectedClusters = new HashSet();
        affectedClusters.addAll(earMapper.getAffectedTargets());
        affectedClusters.addAll(warMapper.getAffectedTargets());
        affectedClusters.addAll(dsMapper.getAffectedTargets());
        affectedClusters.addAll(qMapper.getAffectedTargets());
        affectedClusters.addAll(qcfMapper.getAffectedTargets());
        affectedClusters.addAll(tMapper.getAffectedTargets());
        affectedClusters.addAll(tcfMapper.getAffectedTargets());
        return affectedClusters.isEmpty();
    }

    private Set<Change<WasCluster>> findClusterChangesForDeploymentChange(Change<Deployment> deploymentChange, ChangePlan changePlan) {
        HashSet<Change<WasCluster>> clusterChanges = new HashSet<Change<WasCluster>>();
        for (Change change : changePlan.getChanges()) {
            Change clusterChange;
            if (!change.isModification() || change.getConfigurationItemClass() != WasCluster.class || !this.isClusterDeploymentTarget((WasCluster)((Object)(clusterChange = change).getOldRevision()), (Deployment)deploymentChange.getOldRevision()) || !this.isClusterDeploymentTarget((WasCluster)((Object)clusterChange.getNewRevision()), (Deployment)deploymentChange.getNewRevision())) continue;
            clusterChanges.add((Change<WasCluster>)clusterChange);
        }
        return clusterChanges;
    }

    private boolean isClusterDeploymentTarget(WasCluster cluster, Deployment deployment) {
        List deployableArtifactMappings = deployment.getMappingsOfType(DeployableArtifactMapping.class);
        for (DeployableArtifactMapping eachMapping : deployableArtifactMappings) {
            if (!eachMapping.getTarget().equals((Object)cluster)) continue;
            return true;
        }
        return false;
    }

    private void createApacheVirtualHosts(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (Map.Entry<ApacheHttpdServer, Set<String>> eachVirtualHostPerWebServer : virtualHostsPerWebServer.entrySet()) {
            ApacheHttpdServer eachWebServer = eachVirtualHostPerWebServer.getKey();
            for (String eachVirtualHost : eachVirtualHostPerWebServer.getValue()) {
                steps.add((Step)new CreateApacheHttpdVirtualHostStep(eachWebServer, eachVirtualHost, Collections.singletonList(eachWebServer)));
            }
        }
    }

    private void destroyApacheVirtualHosts(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (Map.Entry<ApacheHttpdServer, Set<String>> eachVirtualHostPerWebServer : virtualHostsPerWebServer.entrySet()) {
            ApacheHttpdServer eachWebServer = eachVirtualHostPerWebServer.getKey();
            for (String eachVirtualHost : eachVirtualHostPerWebServer.getValue()) {
                steps.add((Step)new DestroyApacheHttpdVirtualHostStep(eachWebServer, eachVirtualHost));
            }
        }
    }

    private void restartApacheWebServers(Map<ApacheHttpdServer, Set<String>> virtualHostsPerWebServer, List<Step> steps) {
        for (ApacheHttpdServer eachWebServer : virtualHostsPerWebServer.keySet()) {
            steps.add((Step)new RestartApacheHttpdServerStep(eachWebServer));
        }
    }
}

