package com.xebialabs.deployit.plugin.was.ci;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;

@SuppressWarnings("serial")
@ConfigurationItem
public class WasJndiProperties extends BaseConfigurationItem implements WasResource {

	@ConfigurationItemProperty(description = "Key/value pairs that are to stored in the WebSphere JNDI tree")
	private List<KeyValuePair> stringNameSpaceBindings = new ArrayList<KeyValuePair>();

	public List<KeyValuePair> getStringNameSpaceBindings() {
		return stringNameSpaceBindings;
	}

	public void setStringNameSpaceBindings(List<KeyValuePair> stringNameSpaceBindings) {
		this.stringNameSpaceBindings = stringNameSpaceBindings;
	}

	public void addStringNameSpaceBinding(KeyValuePair binding) {
		if (stringNameSpaceBindings == null) {
			stringNameSpaceBindings = new ArrayList<KeyValuePair>();
		}
		stringNameSpaceBindings.add(binding);
	}

}
