/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;

@SuppressWarnings("serial")
@ConfigurationItem
public class WasManagedApacheHttpdServer extends ApacheHttpdServer {

	@ConfigurationItemProperty(required = true)
	private String name;

	@ConfigurationItemProperty(required = true, description = "The WAS node on which Apache is installed.")
	private WasNode node;

	@ConfigurationItemProperty(required = true, description = "The directory into which in plugin should be installed.", size = Size.LARGE)
	private String pluginInstallationDirPath;

	@ConfigurationItemProperty(required = true, description = "The port where the Apache HTTPD server is running on. e.g. 80, 443")
	private int port;

	@ConfigurationItemProperty(required = true, label = "Type", description = "The Web server vendor type.")
	private WebServerVendorType webServerVendorType = WebServerVendorType.APACHE;
	
	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public WasNode getNode() {
		return node;
	}

	public void setNode(WasNode node) {
		this.node = node;
	}

	public String getPluginInstallationDirPath() {
		return pluginInstallationDirPath;
	}

	public void setPluginInstallationDirPath(String pluginInstallationDirPath) {
		this.pluginInstallationDirPath = pluginInstallationDirPath;
	}

	public void setWebServerVendorType(WebServerVendorType webServerVendorType) {
		this.webServerVendorType = webServerVendorType;
	}

	public WebServerVendorType getWebServerVendorType() {
		return webServerVendorType;
	}

}
