package com.xebialabs.deployit.plugin.was.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;

public class EarToWasClusterMapper extends JeeArtifactToWasClusterMapper<Ear, EarMapping> {

	public EarToWasClusterMapper(Change<Deployment> change) {
		super(change, true);
	}

	@Override
	protected void generateDeployStep(Ear artifact, EarMapping mapping, WasCluster cluster, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
		// vhost name == artifact's name (see generateAdditionStepsForAddedMapping in JeeArtifactToWasClusterMapper)
		steps.add(new WasDeployApplicationStep(cluster.getCell(), artifact, Collections.singleton(cluster), webservers, artifact.getName()));
	}

	@Override
	protected void generateUndeployStep(Ear artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasUndeployApplicationStep(cluster.getCell(), artifact));
	}

	@Override
	protected void generateStartStep(Ear artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasStartApplicationStep(cluster, artifact));
	}

	@Override
	protected void generateStopStep(Ear artifact, WasCluster cluster, List<Step> steps) {
		steps.add(new WasStopApplicationStep(cluster, artifact));
	}

	@Override
	protected String getVirtualHostFromMapping(EarMapping mapping) {
		return mapping.getVirtualHost();
	}

	@Override
	public void setDefaults(Deployment d, EarMapping m) {
		m.setVirtualHost(d.getVhostDefinition());
	}

}
