package com.xebialabs.deployit.plugin.was.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.mapping.Mapping;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasEarMapping;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.step.CreateWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasVirtualHostStep;
import com.xebialabs.deployit.plugin.was.step.SynchronizeWasNodeStep;
import com.xebialabs.deployit.plugin.was.step.UpdateWasVirtualHostAliasesStep;

public abstract class JeeArtifactToWasClusterMapper<S extends NamedDeployableArtifact, M extends Mapping> extends WasStepGeneratingMapper<S, M, WasCluster> {

	public JeeArtifactToWasClusterMapper(Change<Deployment> change, boolean applyDefaultMappings) {
		super(change, applyDefaultMappings);
	}

	@Override
	protected final void generateAdditionStepsForAddedMapping(S ear, M mapping, WasCluster cluster, List<Step> steps) {
		Set<WasManagedApacheHttpdServer> webservers;
		if (mapping instanceof WasEarMapping) {
			webservers = ((WasEarMapping) mapping).getWebservers();
		} else if (mapping instanceof WasWarMapping) {
			webservers = ((WasWarMapping) mapping).getWebservers();
		} else {
			webservers = Collections.emptySet();
		}

		steps.add(new CreateWasVirtualHostStep(cluster.getCell(), ear.getName()));
		steps.add(new UpdateWasVirtualHostAliasesStep(cluster.getCell(), ear.getName(), getVirtualHostFromMapping(mapping)));
		generateDeployStep(ear, mapping, cluster, webservers, steps);

		for (WasManagedApacheHttpdServer eachWebServer : webservers) {
			associateVirtualHostWithWebServer(virtualHostsPerWebServer, eachWebServer, getVirtualHostFromMapping(mapping));
		}

		for (WasNode eachNode : cluster.getNodes()) {
			steps.add(new SynchronizeWasNodeStep(eachNode));
		}

		generateStartStep(ear, cluster, steps);
	}

	@Override
	protected final void generateDeletionStepsForDeletedMapping(S ear, M mapping, WasCluster cluster, List<Step> steps) {
		Set<WasManagedApacheHttpdServer> webservers;
		if (mapping instanceof WasEarMapping) {
			webservers = ((WasEarMapping) mapping).getWebservers();
		} else if (mapping instanceof WasWarMapping) {
			webservers = ((WasWarMapping) mapping).getWebservers();
		} else {
			webservers = Collections.emptySet();
		}

		generateStopStep(ear, cluster, steps);
		generateUndeployStep(ear, cluster, steps);
		steps.add(new DestroyWasVirtualHostStep(cluster.getCell(), ear.getName()));

		for (WasNode eachNode : cluster.getNodes()) {
			steps.add(new SynchronizeWasNodeStep(eachNode));
		}

		for (WasManagedApacheHttpdServer eachWebServer : webservers) {
			associateVirtualHostWithWebServer(virtualHostsPerWebServer, eachWebServer, getVirtualHostFromMapping(mapping));
		}
	}

	protected abstract String getVirtualHostFromMapping(M mapping);

	protected abstract void generateDeployStep(S artifact, M mapping, WasCluster cluster, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps);

	protected abstract void generateUndeployStep(S artifact, WasCluster cluster, List<Step> steps);

	protected abstract void generateStartStep(S artifact, WasCluster cluster, List<Step> steps);

	protected abstract void generateStopStep(S artifact, WasCluster cluster, List<Step> steps);

}
