package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasDataSource;
import com.xebialabs.deployit.plugin.was.step.CreateWasDataSourceStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasDataSourceStep;

public class WasDataSourceToWasClusterMapper extends MappingAgnosticStepGeneratingMapper<WasDataSource, WasCluster> {

	public WasDataSourceToWasClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasDataSource resource, WasCluster cluster, List<Step> steps) {
		steps.add(new CreateWasDataSourceStep(resource, cluster));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasDataSource resource, WasCluster cluster, List<Step> steps) {
		steps.add(new DestroyWasDataSourceStep(resource, cluster));
	}

}
