package com.xebialabs.deployit.plugin.was.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopic;
import com.xebialabs.deployit.plugin.was.step.CreateWasWmqTopicStep;
import com.xebialabs.deployit.plugin.was.step.DestroyWasWmqTopicStep;

public class WasWmqTopicToWasClusterMapper extends MappingAgnosticStepGeneratingMapper<WasWmqTopic, WasCluster> {

	public WasWmqTopicToWasClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WasWmqTopic resource, WasCluster cluster, List<Step> steps) {
		steps.add(new CreateWasWmqTopicStep(cluster, resource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WasWmqTopic resource, WasCluster cluster, List<Step> steps) {
		steps.add(new DestroyWasWmqTopicStep(cluster, resource));
	}

}
