package com.xebialabs.deployit.plugin.was.runbook;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;

public abstract class WasRunBookBase<T extends Serializable> implements RunBook {

	private Class<T> ciType;

	public WasRunBookBase(Class<T> ciType) {
		this.ciType = ciType;
	}

	@SuppressWarnings("unchecked")
	public Collection<ChangeResolution> resolve(ChangePlan changePlan) {
		Collection<ChangeResolution> crs = new ArrayList<ChangeResolution>();
		for (Change eachChange : changePlan.getChanges()) {
			if (eachChange.getConfigurationItemClass() == ciType) {
				List<Step> steps = new ArrayList<Step>();
				resolve(eachChange, changePlan, steps);
				if (!steps.isEmpty()) {
					ChangeResolution cr = new ChangeResolution(eachChange);
					cr.addSteps(steps);
					crs.add(cr);
				}
			}
		}
		return crs;
	}

	protected abstract void resolve(Change<T> change, ChangePlan changePlan, List<Step> steps);
}
