package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WasWmqQueueConnectionFactory} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class CreateWasWmqQueueConnectionFactoryStep extends WasStepBase implements Step {

	public static String CREATE_WMQ_QCF_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-wmq-queue-connection-factory.py";

	private WasCluster cluster;

	private WasWmqQueueConnectionFactory qcf;

	public CreateWasWmqQueueConnectionFactoryStep(WasCluster cluster, WasWmqQueueConnectionFactory qcf) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.qcf = qcf;
		setDescription("Create WebSphere MQ Queue Connection Factory " + ExtendedStringUtils.getQuotedString(qcf.getLabel()) + " in cluster " + cluster.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cluster", cluster);
		context.put("qcf", qcf);
		context.put("qcfQueueManagerHost", qcf.getQueueManagerHost());
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_QCF_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
