package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Destroys a <a href="http://publib.boulder.ibm.com/infocenter/wasinfo/v6r1//index.jsp?topic=/com.ibm.websphere.base.doc/info/aes/ae/tcws_plugin_vhost.html">
 * Virtual Host</a> in a {@link WasCell}
 */
@SuppressWarnings("serial")
public class DestroyWasVirtualHostStep extends WasStepBase {

	protected static final String DESTROY_VIRTUAL_HOST_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-vhost.py";

	protected String vhostName;

	public DestroyWasVirtualHostStep(WasCell cell, String vhostName) {
		super(cell);
		this.vhostName = vhostName;
		setDescription("Destroy WAS virtual host " + ExtendedStringUtils.getQuotedString(vhostName) + " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		return (executeWsadminJythonScriptResource(ctx, DESTROY_VIRTUAL_HOST_SCRIPT_RESOURCE_PATH, vhostName) == 0);
	}

	public String getVhostName() {
		return vhostName;
	}

}
