package com.xebialabs.deployit.plugin.was.step;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopic;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Destroys a {@link WasWmqTopic} in a {@link WasCluster}
 */
@SuppressWarnings("serial")
public class DestroyWasWmqTopicStep extends WasStepBase {

	public static String DESTROY_WMQ_T_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-wmq-topic.py";

	private WasCluster cluster;

	private WasWmqTopic t;

	public DestroyWasWmqTopicStep(WasCluster cluster, WasWmqTopic t) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.t = t;
		setDescription("Destroy WebSphere MQ Topic " + ExtendedStringUtils.getQuotedString(t.getLabel()) + " in cluster " + cluster.getLabel());
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("cluster", cluster);
		context.put("t", t);
		int res = executeWsadminJythonScriptResource(ctx, context, DESTROY_WMQ_T_SCRIPT_RESOURCE_PATH);
		return res == 0;
	}

}
