package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasNode;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Starts a single member of a {@link WasCluster} on a {@link WasNode}
 */
@SuppressWarnings("serial")
public class StartWasSingleClusterMemberStep extends WasStepBase {

	protected static final String START_SINGLE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "start-single-cluster-member.py";

	protected WasCluster cluster;

	protected WasNode node;

	private int cloneNumber;

	public StartWasSingleClusterMemberStep(WasCluster cluster, WasNode node, int cloneNumber) {
		super(cluster.getCell());
		this.cluster = cluster;
		this.node = node;
		this.cloneNumber = cloneNumber;
		setDescription("Start members of cluster " + ExtendedStringUtils.getQuotedString(cluster.getLabel()) + " on node " + ExtendedStringUtils.getQuotedString(node.getLabel())
				+ " in cell " + ExtendedStringUtils.getQuotedString(cell.getLabel()));
	}

	public boolean execute(StepExecutionContext ctx) {
		String clusterMemberNamesPrefix = WasCluster.getMemberNamesPrefix(cluster.getName(), node.getName());
		String clusterMemberNumber = Integer.toString(cloneNumber);

		return (executeWsadminJythonScriptResource(ctx, START_SINGLE_CLUSTER_MEMBER_SCRIPT_RESOURCE_PATH, node.getName(), clusterMemberNamesPrefix, clusterMemberNumber) == 0);
	}

}
