/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WasStepBase
implements Step {
    public static final String STEP_RESOURCES_PATH = "com/xebialabs/deployit/plugin/was/step/";
    protected String description;
    protected WasCell cell;
    private static Logger logger = Logger.getLogger(WasStepBase.class);

    protected WasStepBase(WasCell cell) {
        this.cell = cell;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int executeWsadminJythonScriptResource(StepExecutionContext ctx, HostSession s, String scriptResourcePath, String ... args) {
        StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
        String scriptPath = s.copyToTemporaryFile((Resource)new ClassPathResource(scriptResourcePath)).getPath();
        return this.cell.executeWsadminJythonScript((CommandExecutionCallbackHandler)handler, s, scriptPath, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeWsadminJythonScriptResource(StepExecutionContext ctx, String scriptResourcePath, String ... args) {
        HostSession s = this.cell.connectToAdminHost();
        try {
            int n = this.executeWsadminJythonScriptResource(ctx, s, scriptResourcePath, args);
            return n;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeWsadminJythonScriptResource(StepExecutionContext ctx, Map<String, Serializable> context, String scriptResourcePath, String ... args) {
        HostSession s = this.cell.connectToAdminHost();
        try {
            byte[] contextBytes;
            StringBuilder c = new StringBuilder();
            for (Map.Entry<String, Serializable> contextEntry : context.entrySet()) {
                String contextObjectName = contextEntry.getKey();
                Serializable contextObject = contextEntry.getValue();
                c.append(contextObjectName + " = {}\n");
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(contextObject.getClass());
                    for (PropertyDescriptor eachPropertyDescriptor : beanInfo.getPropertyDescriptors()) {
                        String fieldName = eachPropertyDescriptor.getName();
                        try {
                            String fieldValueAsString;
                            Object fieldValueAsObject = eachPropertyDescriptor.getReadMethod().invoke((Object)contextObject, new Object[0]);
                            if (fieldValueAsObject == null || (fieldValueAsString = WasStepBase.encodeAsPythonString(fieldValueAsObject)) == null) continue;
                            c.append(contextObjectName + "['" + fieldName + "'] = '" + fieldValueAsString + "'\n");
                        }
                        catch (IllegalAccessException exc) {
                            logger.warn((Object)("Cannot retrieve field values from object " + contextObjectName + ". Ignoring it."), (Throwable)exc);
                        }
                        catch (InvocationTargetException exc) {
                            logger.warn((Object)("Cannot retrieve field values from object " + contextObjectName + ". Ignoring it."), (Throwable)exc);
                        }
                    }
                }
                catch (IntrospectionException exc) {
                    logger.warn((Object)("Cannot retrieve field values from object " + contextObjectName + ". Ignoring it."), (Throwable)exc);
                }
            }
            c.append("execfile(sys.argv.pop(0))\n");
            HostFile contextScript = s.getTempFile("context-for-" + FilenameUtils.getBaseName((String)scriptResourcePath), ".py");
            try {
                contextBytes = c.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unexpected) {
                throw new IllegalStateException(unexpected);
            }
            contextScript.put((InputStream)new ByteArrayInputStream(contextBytes), (long)contextBytes.length);
            String contextScriptPath = contextScript.getPath();
            String scriptPath = s.copyToTemporaryFile((Resource)new ClassPathResource(scriptResourcePath)).getPath();
            String[] newArgs = new String[args.length + 1];
            newArgs[0] = scriptPath;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
            int n = this.cell.executeWsadminJythonScript((CommandExecutionCallbackHandler)handler, s, contextScriptPath, newArgs);
            return n;
        }
        finally {
            s.close();
        }
    }

    private static String encodeAsPythonString(Object fieldValueAsObject) {
        StringBuilder b = new StringBuilder();
        String s = fieldValueAsObject.toString();
        if (s == null) {
            return null;
        }
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    b.append("\\n");
                    continue block6;
                }
                case '\r': {
                    b.append("\\r");
                    continue block6;
                }
                case '\t': {
                    b.append("\\t");
                    continue block6;
                }
                case '\\': {
                    b.append("\\\\");
                    continue block6;
                }
                default: {
                    if (c < ' ') continue block6;
                    b.append(c);
                }
            }
        }
        return b.toString();
    }
}

