import sys;

dsName					= sys.argv.pop(0)
dsDescription			= sys.argv.pop(0)
jndiName				= sys.argv.pop(0)
providerName			= sys.argv.pop(0)
datastoreHelperClassName = sys.argv.pop(0)
url						= sys.argv.pop(0)
username				= sys.argv.pop(0)
password				= sys.argv.pop(0)
stmtCacheSize			= sys.argv.pop(0)
cellName			= sys.argv.pop(0)
clusterName			= sys.argv.pop(0)

# Look for JDBC Provider with name <providerName>
providerId = AdminConfig.getid('/ServerCluster:' + clusterName + '/JDBCProvider:' + providerName);
if providerId == "":
	providerId = AdminConfig.getid('/Cell:' + cellName + '/JDBCProvider:' + providerName);
	jaasName = dsName + '_user'
	if providerId == "":
	  print 'Deployit INFO: Cannot find JDBC provider "' + providerName + '"'
	  sys.exit(-1)
	print 'Deployit INFO: Using JDBC provider at cell scope'
else:
	print 'Deployit INFO: Using JDBC provider at cluster scope'
	jaasName = 'cluster_' + clusterName + '_' + dsName + '_user'

# Look for Security node
securityid = AdminConfig.list('Security')
if securityid == "":
	print 'Deployit INFO: Cannot find Security node'
	sys.exit(-1)

# Create JAASAuthData with name <jaasName>
print 'Deployit INFO: Creating JAAS/J2C authentication data "' + jaasName + '"'
authdataId = AdminConfig.create('JAASAuthData', securityid, [['alias', jaasName], ['userId', username], ['password', password]])

# Create DataSource with name <dsName>
print 'Deployit INFO: Creating JDBC DataSource "'+ dsName + '"'
dsId = AdminTask.createDatasource(providerId,
	'[-name "' + dsName + '"' +
	' -description "' + dsDescription + '"' +
	' -jndiName "' + jndiName + '"' +
	' -dataStoreHelperClassName "'+ datastoreHelperClassName + '"' +
	' -componentManagedAuthenticationAlias "' + jaasName + '"' +
	' -configureResourceProperties [[URL java.lang.String ' + url + ']]]')

# Modify DataSource to set statementCacheSize
AdminConfig.modify(dsId, [['statementCacheSize', stmtCacheSize]]);

# Save configuration
print 'Deployit INFO: Saving configuration'
AdminConfig.save();
