# Simple WSADmin/Jython script to stop a cluster in WAS 6.1 and 5.1
# Checks whether cluster with passed argument already exists.
# If true, then starts the cluster
# Usage: wsadmin -f start-webspherecluster.py <clustername> <forced>

import sys
import java

clustername = sys.argv[0];
forced = sys.argv[1];

cluster = AdminControl.completeObjectName('type=Cluster,name='+clustername+',*')

if cluster != "" :
	state = AdminControl.getAttribute(cluster, 'state');
	if state == "websphere.cluster.stopped":
		print "Deployit INFO: ServerCluster : "+clustername+ "STOPPED";
		sys.exit(0);
	else:
		if forced == "true" :
			print "Deployit INFO: forcibly Stopping all servers on ServerCluster : "+clustername;
			clid = AdminConfig.getid('/ServerCluster:'+clustername+'/');
			members = AdminConfig.list('ClusterMember', clid);
			lineSeparator = java.lang.System.getProperty('line.separator');
			arrayAllClusterMembers = members.split(lineSeparator);
			for member in arrayAllClusterMembers :
				membername =  AdminConfig.showAttribute(member, 'memberName');
				nodename = AdminConfig.showAttribute(member, 'nodeName');
				print "Deployit INFO: forcibly stopping cluster member : " + membername + " on node: "  + nodename;
				AdminControl.stopServer(membername, nodename, 'immediate');
		else:
			print "Deployit INFO: Stopping ServerCluster : "+clustername;
			AdminControl.invoke(cluster, 'stop');

		AdminConfig.save();
		print "Deployit INFO: Stopped ServerCluster : "+clustername;
		sys.exit(0);
else :
	print "Deployit INFO: ServerCluster : "+clustername+ " does't exist. There is nothing to do.";
	sys.exit(0);
