#
# Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

# Simple WSADmin/Jython script to stop a cluster in WAS 6.1 and 5.1
# Checks whether cluster with passed argument already exists.
# If true, then starts the cluster
# Usage: wsadmin -f start-webspherecluster.py <clustername> <forced>

import sys
import java

clustername = sys.argv[0];
forced = sys.argv[1];

cluster = AdminControl.completeObjectName('type=Cluster,name='+clustername+',*')

if cluster == "" :
    print "Cluster " + clustername + " does not exist.";
    sys.exit(1);

state = AdminControl.getAttribute(cluster, 'state');
if state == "websphere.cluster.stopped":
	print "Cluster  " + clustername + " is already stopped. Doing nothing.";
	sys.exit(0);

if forced == "true" :
	print "Forcibly Stopping all members of cluster "+clustername;
	clid = AdminConfig.getid('/ServerCluster:'+clustername+'/');
	members = AdminConfig.list('ClusterMember', clid);
	lineSeparator = java.lang.System.getProperty('line.separator');
	arrayAllClusterMembers = members.split(lineSeparator);
	for member in arrayAllClusterMembers :
		membername =  AdminConfig.showAttribute(member, 'memberName');
		nodename = AdminConfig.showAttribute(member, 'nodeName');
		print "Forcibly stopping cluster member " + membername + " on node "  + nodename;
		AdminControl.stopServer(membername, nodename, 'immediate');
else:
	print "Stopping cluster " + clustername;
	AdminControl.invoke(cluster, 'stop');
