/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.io.Serializable;
import java.util.HashMap;

public class CreateWasManagedApacheWebServerStep
extends WasStepBase {
    private static final String CREATE_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-was-managed-apache-web-server.py";
    private WasManagedApacheHttpdServer webserver;

    public CreateWasManagedApacheWebServerStep(WasManagedApacheHttpdServer webserver) {
        super(webserver.getNode().getCell());
        this.webserver = webserver;
        this.setDescription("Create WAS managed Apache web server " + (Object)((Object)webserver) + " on node " + webserver.getNode() + " in cell " + webserver.getNode().getCell());
    }

    public boolean execute(StepExecutionContext ctx) {
        this.createApacheHttpdServerConfigFragmentForWasPlugin(ctx);
        int res = this.createApacheHttpdServerConfigurationInWas(ctx);
        return res == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createApacheHttpdServerConfigFragmentForWasPlugin(StepExecutionContext ctx) {
        HostSession rhs = this.webserver.getHost().getHostSession();
        try {
            HostFile fragmentFile = rhs.getFile(this.webserver.getApacheHttpdServerConfigFragmentPath());
            String fragmentContent = this.webserver.getApacheHttpdServerConfigFragmentContent();
            ctx.logOutput("Creating Apache configuration fragment " + fragmentFile.getPath() + " for WAS plugin");
            HostFileUtils.putStringToHostFile((String)fragmentContent, (HostFile)fragmentFile);
        }
        finally {
            rhs.close();
        }
    }

    private int createApacheHttpdServerConfigurationInWas(StepExecutionContext ctx) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("webserver", (Serializable)((Object)this.webserver));
        context.put("node", this.webserver.getNode());
        context.put("cell", this.webserver.getNode().getCell());
        return this.executeWsadminJythonScriptResource(ctx, context, CREATE_WAS_MANAGED_APACHE_WEB_SERVER_SCRIPT_RESOURCE_PATH, new String[0]);
    }
}

