/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.plugin.was.utils.WasWarUtils;
import com.xebialabs.deployit.plugin.was.utils.WebSphereNameBuilder;

@SuppressWarnings("serial")
@ConfigurationItem(description = "A mapping of a WAR to WebSphere middleware")
public class WasWarMapping extends WarMapping<WasTarget> {

	@ConfigurationItemProperty(description = "Set of webservers that expose the Eneterprise Application")
	private Set<WasManagedApacheHttpdServer> webservers;

	@ConfigurationItemProperty(description = "Specifies the order in which applications are started. Lower values start earlier.")
	private int startingWeight = 1;

	@ConfigurationItemProperty(description = "Set of shared library which will used by the war", category = "Shared library references")
	private Set<WasSharedLibrary> sharedLibraries;

	@ConfigurationItemProperty(description = "Specifies the Classloader mode", category = "Class loading")
	private WasClassLoaderMode classLoaderMode;

	@ConfigurationItemProperty(description = "Map Security role to users and groups used by EnterPrise Application", category = "Security")
	private List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings;

	@ConfigurationItemProperty(description = "If true, the artifact name will be suffixed with the name of the target.")
	private boolean suffixArtifactNameWithTarget = false;

	@ConfigurationItemProperty(description = "Set File Serving enabled to WAR")
	private WasFileServing fileServing = WasFileServing.DO_NOT_OVERRIDE;

	@SuppressWarnings("unchecked")
	public WasWarMapping() {
		// default constructor
		this.webservers = Collections.EMPTY_SET;
		this.sharedLibraries = Collections.EMPTY_SET;
	}

	@SuppressWarnings("unchecked")
	public WasWarMapping(War source, WasTarget target, String virtualHost, String contextRoot) {
		this(source, target, Collections.EMPTY_SET, Collections.EMPTY_SET, virtualHost, contextRoot);
	}

	public WasWarMapping(War source, WasTarget target, Set<WasManagedApacheHttpdServer> webservers, Set<WasSharedLibrary> sharedLibraries, String virtualHost,
	        String contextRoot) {
		super(source, target, virtualHost, contextRoot);
		this.webservers = webservers;
		this.sharedLibraries = sharedLibraries;
	}

	@Override
	public void postInit(Deployment deployment) {
		this.securityRoleUserGroupMappings = WasWarUtils.getSecurityRoleUserGroupMappings(getSource());
		super.postInit(deployment);
	}
	
	// see the comment at WasEarMapping
	@Override
	public War getSource() {
		War war = super.getSource();
		if (!suffixArtifactNameWithTarget) {
			return war;
		}

		War warWithSuffixedName = new War();
		warWithSuffixedName.setLabel(war.getLabel());
		warWithSuffixedName.setLocation(war.getLocation());
		warWithSuffixedName.setName(WebSphereNameBuilder.getDeployedApplicationName(war, this));
		return warWithSuffixedName;
	}

	public Set<WasManagedApacheHttpdServer> getWebservers() {
		return webservers;
	}

	public void setWebservers(Set<WasManagedApacheHttpdServer> webservers) {
		this.webservers = webservers;
	}

	public int getStartingWeight() {
		return startingWeight;
	}

	public void setStartingWeight(int startingWeight) {
		this.startingWeight = startingWeight;
	}

	public Set<WasSharedLibrary> getSharedLibraries() {
		return sharedLibraries;
	}

	public void setSharedLibraries(Set<WasSharedLibrary> sharedLibraries) {
		this.sharedLibraries = sharedLibraries;
	}

	public List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings() {
		return securityRoleUserGroupMappings;
	}

	public void setSecurityRoleUserGroupMappings(List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings) {
		this.securityRoleUserGroupMappings = securityRoleUserGroupMappings;
	}

	public WasClassLoaderMode getClassLoaderMode() {
		return classLoaderMode;
	}

	public void setClassLoaderMode(WasClassLoaderMode classLoaderMode) {
		this.classLoaderMode = classLoaderMode;
	}

	public boolean isSuffixArtifactNameWithTarget() {
		return suffixArtifactNameWithTarget;
	}

	public void setSuffixArtifactNameWithTarget(boolean suffixArtifactNameWithTarget) {
		this.suffixArtifactNameWithTarget = suffixArtifactNameWithTarget;
	}

	public WasFileServing getFileServing() {
		return fileServing;
	}

	public void setFileServing(WasFileServing fileServing) {
		this.fileServing = fileServing;
	}

}
