/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.utils;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderMode;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasWarClassLoaderMapping;
import com.xebialabs.deployit.plugin.was.utils.WasUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WasEarUtils {
    public static List<String> getWarsInEar(Ear ear) {
        ArrayList<String> wars = new ArrayList<String>();
        NodeList warNodes = WasUtils.getNodesWithTag("web", (NamedDeployableArtifact)ear, "META-INF/application.xml");
        if (warNodes != null) {
            for (int i = 0; i < warNodes.getLength(); ++i) {
                Element warNode = (Element)warNodes.item(i);
                String name = WasUtils.findName(warNode, "web-uri");
                if (name == null) continue;
                wars.add(name);
            }
        }
        return wars;
    }

    public static Set<String> getSecurityRolesInEar(Ear ear) {
        HashSet<String> securityRoles = new HashSet<String>();
        NodeList warNodes = WasUtils.getNodesWithTag("web", (NamedDeployableArtifact)ear, "META-INF/application.xml");
        if (warNodes != null) {
            for (int i = 0; i < warNodes.getLength(); ++i) {
                NodeList securityRolesList;
                Element warNode = (Element)warNodes.item(i);
                String name = WasUtils.findName(warNode, "web-uri");
                if (name == null || (securityRolesList = WasEarUtils.getNodesWithTagInJarEntry("security-role", ear, name)) == null) continue;
                for (int j = 0; j < securityRolesList.getLength(); ++j) {
                    Element securityRole = (Element)securityRolesList.item(j);
                    String roleName = WasUtils.findName(securityRole, "role-name");
                    if (roleName == null) continue;
                    securityRoles.add(roleName);
                }
            }
        }
        return securityRoles;
    }

    private static NodeList getNodesWithTagInJarEntry(String tag, Ear ear, String jarEntryName) {
        try {
            JarFile jarFile = new JarFile(new File(ear.getLocation()));
            JarEntry jarEntry = jarFile.getJarEntry(jarEntryName);
            if (jarEntry != null) {
                InputStream is = jarFile.getInputStream(jarEntry);
                JarInputStream inputStream = new JarInputStream(is);
                JarEntry jarEntryWebXml = null;
                while ((jarEntryWebXml = inputStream.getNextJarEntry()) != null && !jarEntryWebXml.getName().endsWith("web.xml")) {
                    jarEntryWebXml = null;
                }
                if (jarEntryWebXml == null) {
                    return null;
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                WasUtils.disableDtdValidation(db);
                Document doc = db.parse(new InputSource(inputStream));
                NodeList resourceRefNodes = doc.getElementsByTagName(tag);
                inputStream.close();
                is.close();
                jarFile.close();
                return resourceRefNodes;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Ear file not found for Ear named " + ear.getName());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Parser configuration Exception while trying to parse application.xml for Ear named " + ear.getName());
        }
        catch (SAXException e) {
            throw new RuntimeException("Parser Exception while parsing web.xml for Ear named " + ear.getName());
        }
    }

    public static List<SecurityRoleUserGroupMappings> getSecurityRoleUserGroupMappings(Ear source) {
        ArrayList securityRoleUserGroupMappingList = Lists.newArrayList();
        Set<String> securityroles = WasEarUtils.getSecurityRolesInEar(source);
        for (String roleName : securityroles) {
            SecurityRoleUserGroupMappings securityRoleUserGroupMappings = new SecurityRoleUserGroupMappings(roleName, "", "");
            securityRoleUserGroupMappingList.add(securityRoleUserGroupMappings);
        }
        return securityRoleUserGroupMappingList;
    }

    public static List<WarsWebserversVirtualHostMapping> getWarsWebserversMapping(Ear source) {
        ArrayList webserversVHMappings = Lists.newArrayList();
        List<String> wars = WasEarUtils.getWarsInEar(source);
        for (String war : wars) {
            webserversVHMappings.add(new WarsWebserversVirtualHostMapping(war, "", "", "", WasFileServing.DO_NOT_OVERRIDE));
        }
        return webserversVHMappings;
    }

    public static List<WasWarClassLoaderMapping> getWasWarClassLoaderMappings(Ear Source2) {
        ArrayList warClassLoaderList = Lists.newArrayList();
        List<String> warNames = WasEarUtils.getWarsInEar(Source2);
        for (String war : warNames) {
            warClassLoaderList.add(new WasWarClassLoaderMapping(war, WasClassLoaderMode.PARENT_FIRST));
        }
        return warClassLoaderList;
    }
}

