/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.mapper;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasCluster;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarMapping;
import com.xebialabs.deployit.plugin.was.mapper.JeeWebArtifactToWasTargetMapper;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStopApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasUndeployApplicationStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarToWasClusterMapper
extends JeeWebArtifactToWasTargetMapper<War, WasWarMapping, WasCluster> {
    public WarToWasClusterMapper(Change<Deployment> change) {
        super(change, false);
    }

    @Override
    protected void generateDeployStep(War artifact, WasWarMapping mapping, WasCluster cluster, Collection<WasManagedApacheHttpdServer> webservers, List<Step> steps) {
        steps.add(new WasDeployApplicationStep(cluster.getCell(), mapping.getArtifact(), Collections.singleton(cluster), webservers, artifact.getName(), mapping.getSharedLibraries(), mapping.getContextRoot(), mapping.getStartingWeight(), mapping.getClassLoaderMode(), mapping.getResourceEnvironmentEntryReferences(), mapping.getResourceReferences(), mapping.getEjbReferences(), mapping.getSecurityRoleUserGroupMappings()));
    }

    @Override
    protected void generateUndeployStep(War artifact, WasCluster cluster, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasUndeployApplicationStep((WasCell)cluster.getCell(), mapping.getArtifact()));
    }

    @Override
    protected void generateStartStep(War artifact, WasCluster cluster, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasStartApplicationStep((WasTarget)cluster, mapping.getArtifact()));
    }

    @Override
    protected void generateStopStep(War artifact, WasCluster cluster, WasWarMapping mapping, List<Step> steps) {
        steps.add(new WasStopApplicationStep((WasTarget)cluster, mapping.getArtifact()));
    }

    @Override
    protected String getVirtualHostFromMapping(WasWarMapping mapping) {
        return mapping.getVirtualHost();
    }

    public void setDefaults(Deployment d, WasWarMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
        m.setContextRoot(((War)m.getSource()).getName());
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getWebserversAndVirtualHostPerWar(WasWarMapping mapping) {
        return Lists.newArrayList();
    }

    @Override
    protected List<WarsWebserversVirtualHostMapping> getFileServingEnabledPerWars(WasWarMapping mapping) {
        ArrayList fileServingEnabledPerWars = Lists.newArrayList();
        if (mapping.getFileServing() != null && mapping.getFileServing() != WasFileServing.DO_NOT_OVERRIDE) {
            fileServingEnabledPerWars.add(new WarsWebserversVirtualHostMapping(((War)mapping.getSource()).getName() + "." + "war", "", "", "", mapping.getFileServing()));
        }
        return fileServingEnabledPerWars;
    }
}

