/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.ci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.step.CheckWasAdminAvailableStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasCellNameStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerApplicationServerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerErrorStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaProcessPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerJavaVirtualMachinePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerOutputStreamRedirectPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerProcessExecutionPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerDefaultCookiePropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerSessionManagerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerTuningPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasServerWebContainerPropertiesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasSubtypesStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasUnmanagedServerNameBySoapPortStep;
import com.xebialabs.deployit.plugin.was.step.RetrieveWasVersionStep;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;

/**
 * An unmanaged WebSphere Application Server.
 */
@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "An unmanaged WebSphere Applicaton Server (WAS Base/SA)", discoverable = true)
public class WasUnmanagedServer extends WasServer implements WasCell, WasNode, Discoverable<WasUnmanagedServer> {

	@ConfigurationItemProperty(required = true, asContainment = true, description = "Host on which the unmanaged WAS server runs")
	private Host host;

	@ConfigurationItemProperty(required = true, label = "WebSphere cell name", identifying = true, description = "Name of the WebSphere cell, e.g. MyCell, WASCell, Cell01")
	private String cellName;

	@ConfigurationItemProperty(required = true, label = "WebSphere node name", identifying = true, description = "Name of the WebSphere node")
	private String nodeName;

	@ConfigurationItemProperty(required = true, label = "WebSphere Installation Path", description = "Root path of the WebSphere installation path. e.g. /opt/ws/6.1/appserver/profiles/AppSrv01", size = Size.LARGE, discoveryParam = true)
	private String wasHome;

	@ConfigurationItemProperty(required = false, label = "Administrative port", description = "TCP port which is used to login to the WebSphere Administration, default is 8880", discoveryParam = true)
	private int port;

	@ConfigurationItemProperty(required = false, label = "Administrative username", description = "Username which is used to login to the WebSphere Administration.", discoveryParam = true)
	private String username;

	@ConfigurationItemProperty(required = false, label = "Administrative password", description = "Password which is used to login to the WebSphere Administration.", password = true, discoveryParam = true)
	private String password;

	@ConfigurationItemProperty(required = true, label = "WAS version", description = "Version of WebSphere Application Server.")
	private WasVersion version;

	@ConfigurationItemProperty(required = false, label = "Resource environment jndi names")
	private Set<String> resourceEnvironmentJndiNames = new HashSet<String>();

	protected transient WasCellConfigurationExecutor executor;

	private WasCellConfigurationExecutor getWasCellConfigurationExecutor() {
		if (executor == null) {
			executor = new WasCellConfigurationExecutor(this);
		}
		return executor;
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getCellName() {
		return cellName;
	}

	public void setCellName(String cellName) {
		this.cellName = cellName;
	}

	@Override
	public String getNodeName() {
		return nodeName;
	}

	public void setNodeName(String nodeName) {
		this.nodeName = nodeName;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getWasHome() {
		return wasHome;
	}

	public void setWasHome(String wasHome) {
		this.wasHome = wasHome;
	}

	public WasVersion getVersion() {
		return version;
	}

	public void setVersion(WasVersion version) {
		this.version = version;
	}

	public WasCell getCell() {
		return this;
	}

	public Host getCellHost() {
		return host;
	}

	public Collection<WasNodeAgent> getNodes() {
		return Collections.emptySet();
	}

	public HostSession connectToAdminHost() {
		return getWasCellConfigurationExecutor().connectToAdminHost();
	}

	public int executeWsadminJythonScript(StepExecutionContext ctx, HostSession cellHostSession, String scriptPath, String... args) {
		return getWasCellConfigurationExecutor().executeWsadminJythonScript(ctx, cellHostSession, scriptPath, args);
	}

	public Map<String, String> getCellPropertiesInfo(StepExecutionContext ctx) {
		return getWasCellConfigurationExecutor().getCellPropertiesInfo(ctx);
	}

	public String getConfigDirPath() {
		return getWasCellConfigurationExecutor().getConfigDirPath();
	}

	public Map<String, String> getObjectInfo(StepExecutionContext ctx, String objectContainmentPath) {
		return getWasCellConfigurationExecutor().getObjectInfo(ctx, objectContainmentPath);
	}

	public Map<String, String> getObjectInfoWithSubLevelByName(StepExecutionContext ctx, String objectContainmentPath, String subLevelName) {
		return getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByName(ctx, objectContainmentPath, subLevelName);
	}

	public Map<String, String> getObjectInfoWithSubLevelByType(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
		return getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByType(ctx, objectContainmentPath, subLevelType);
	}

	public Map<String, String> getObjectInfoWithSubLevelByTypeAndName(StepExecutionContext ctx, String objectContainmentPath, String subLevelType,
	        String subLevelName) {
		return getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByTypeAndName(ctx, objectContainmentPath, subLevelType, subLevelName);
	}

	public Collection<String> getObjectInfoWithSubLevelByTypeNamesOnly(StepExecutionContext ctx, String objectContainmentPath, String subLevelType) {
		return getWasCellConfigurationExecutor().getObjectInfoWithSubLevelByTypeNamesOnly(ctx, objectContainmentPath, subLevelType);
	}

	public String getPluginFilePath() {
		return getWasCellConfigurationExecutor().getPluginFilePath();
	}

	public String getVersionInfoPath() {
		return getWasCellConfigurationExecutor().getVersionInfoPath();
	}

	public String getWsadminPath() {
		return getWasCellConfigurationExecutor().getWsadminPath();
	}

	public String getWasConfigIdType() {
		return "Server";
	}

	public String getWasTargetType() {
		return "server";
	}

	public String getShortTypeDescription() {
		return "unmanaged server";
	}

	public WasUnmanagedServer discover(Map<String, Object> info, ChangePlan cp) {
		List<Step> steps = getCheckAndNodeAndServerSteps();
		cp.addSteps(steps);
		cp.execute(info);
		return this;
	}

	public WasUnmanagedServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
		return null;
	}

	private List<Step> getCheckAndNodeAndServerSteps() {
		List<Step> steps = new ArrayList<Step>();
		steps.add(new HostConnectionStep(getHost()));
		steps.add(new CheckDirExistsStep(getHost(), getWasHome()));
		steps.add(new CheckDirExistsStep(getHost(), getConfigDirPath()));
		steps.add(new CheckFileExistenceStep(getHost(), getVersionInfoPath(), true, false, true));
		steps.add(new RetrieveWasVersionStep(this));
		steps.add(new CheckFileExistenceStep(getHost(), getWsadminPath(), true, false, true));
		steps.add(new CheckWasAdminAvailableStep(this));
		steps.add(new RetrieveWasCellNameStep(this));
		steps.add(new RetrieveWasSubtypesStep(this));
		steps.add(new SetNodeNameStep());
		steps.add(new RetrieveWasUnmanagedServerNameBySoapPortStep(this));

		steps.add(new RetrieveWasServerApplicationServerPropertiesStep(this));
		steps.add(new RetrieveWasServerErrorStreamRedirectPropertiesStep(this));
		steps.add(new RetrieveWasServerJavaProcessPropertiesStep(this));
		steps.add(new RetrieveWasServerJavaVirtualMachinePropertiesStep(this));
		steps.add(new RetrieveWasServerOutputRedirectPropertiesStep(this));
		steps.add(new RetrieveWasServerOutputStreamRedirectPropertiesStep(this));
		steps.add(new RetrieveWasServerProcessExecutionPropertiesStep(this));
		steps.add(new RetrieveWasServerSessionManagerDefaultCookiePropertiesStep(this));
		steps.add(new RetrieveWasServerSessionManagerPropertiesStep(this));
		steps.add(new RetrieveWasServerTuningPropertiesStep(this));
		steps.add(new RetrieveWasServerWebContainerPropertiesStep(this));
		return steps;
	}

	public String getStartServerPath() {
		return getWasCellConfigurationExecutor().getStartServerPath();
	}

	public String getStopServerPath() {
		return getWasCellConfigurationExecutor().getStopServerPath();
	}

	public String getServerStatusPath() {
		return getWasCellConfigurationExecutor().getServerStatusPath();
	}

	class SetNodeNameStep implements Step {
		@SuppressWarnings("unchecked")
		public boolean execute(StepExecutionContext ctx) {
			if (ctx.getAttribute("WasNode") != null) {
				Collection<String> nodeNames = (Collection<String>) ctx.getAttribute("WasNode");
				if (nodeNames.size() == 1) {
					setNodeName(nodeNames.iterator().next());
				} else {
					throw new ResolutionException(getShortTypeDescription() + " can only contain one node and not " + nodeNames.size());
				}
				return true;
			} else {
				ctx.logError("Unable to find nodename");
				return false;
			}
		}

		public String getDescription() {
			return "Setting Nodename";
		}
	}

	public Set<String> getResourceEnvironmentJndiNames() {
		return resourceEnvironmentJndiNames;
	}

	public void setResourceEnvironmentJndiNames(Set<String> resourceEnvironmentJndiNames) {
		this.resourceEnvironmentJndiNames = resourceEnvironmentJndiNames;
	}
}
