/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasUnManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;

public class CopyWasWebServerPluginConfigurationStep
extends WasStepBase {
    protected WasUnManagedApacheHttpdServer webserver;

    public CopyWasWebServerPluginConfigurationStep(WasUnManagedApacheHttpdServer webserver) {
        super(webserver.getNode().getCell());
        this.webserver = webserver;
        this.setDescription("Copy WebSphere plugin configuration file from " + webserver.getPluginCfgInWasConfigurationPath() + " on " + webserver.getNode().getCell().getCellHost() + " to " + webserver.getPluginCfgOnRemoteServerPath() + " on " + webserver.getHost());
    }

    public boolean execute(StepExecutionContext ctx) {
        return this.copyPluginToWebserver(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyPluginToWebserver(StepExecutionContext ctx) {
        HostSession sourceSession = this.webserver.getNode().getCell().connectToAdminHost();
        try {
            boolean bl;
            HostFile sourceFile = sourceSession.getFile(this.webserver.getPluginCfgInWasConfigurationPath());
            HostSession destinationSession = this.webserver.getHost().getHostSession();
            try {
                HostFile destinationFile = destinationSession.getFile(this.webserver.getPluginCfgOnRemoteServerPath());
                HostFile destinationParentDir = destinationFile.getParentFile();
                if (!destinationParentDir.exists()) {
                    ctx.logOutput("Creating directory structure for plugin configuration file in " + destinationParentDir);
                    destinationParentDir.mkdirs();
                }
                ctx.logOutput("Copying WebSphere plugin configuration file from " + this.webserver.getPluginCfgInWasConfigurationPath() + " on " + this.webserver.getNode().getCell().getCellHost() + " to " + destinationFile + " on " + this.webserver.getHost());
                HostFileUtils.copy((HostFile)sourceFile, (HostFile)destinationFile);
                bl = true;
            }
            catch (Throwable throwable) {
                destinationSession.close();
                throw throwable;
            }
            destinationSession.close();
            return bl;
        }
        finally {
            sourceSession.close();
        }
    }
}

