/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

/**
 * A JDBC Datasource defined in a {@link WlsDomain WLS domain}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A datasource to connect to a database.")
public class WlsDataSource extends WlsResource {

	@ConfigurationItemProperty(required = true, description = "The name of the datasource in the WebLogic configuration, e.g. Order DataSource")
	private String name;

	@ConfigurationItemProperty(required = true, description = "The JNDI name of the datasource, e.g. jdbc/orderdb")
	private String jndiName;

	@ConfigurationItemProperty(required = true, size = Size.LARGE, label = "URI", description = "The JDBC uri to the database, e.g. jdbc:oracle:thin:@ora-prod:1521:orders")
	private String uri;

	@ConfigurationItemProperty(description = "The username credential for the database, e.g. scott")
	private String userName;

	@ConfigurationItemProperty(description = "The password credential for the database, e.g. tiger", password = true)
	private String password;

	@ConfigurationItemProperty(required = true, description = "The driver of the datasource, the classname, e.g. oracle.jdbc.xa.client.OracleXADataSource")
	private String driver;

	@ConfigurationItemProperty(required = true, category = "Connection Pool", description = "The initial connectionpool size.")
	private int init;

	@ConfigurationItemProperty(required = true, category = "Connection Pool", description = "The maximum connectionpool size.")
	private int max;

	@ConfigurationItemProperty(category = "Connection Pool", description = "A comma separated list of name=value pairs.")
	private String properties;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getDriver() {
		return driver;
	}

	public void setDriver(String driver) {
		this.driver = driver;
	}

	public int getInit() {
		return init;
	}

	public void setInit(int init) {
		this.init = init;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	public String getProperties() {
		return properties;
	}

	public void setProperties(String properties) {
		this.properties = properties;
	}
}
