/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Modifies a {@link WlsJmsQueue JMS queue}.
 */
@SuppressWarnings("serial")
public class ModifyWlsJmsQueueStep extends SimpleWlstExecutingStep {

	public ModifyWlsJmsQueueStep(WlsServer server, WlsJmsQueue oldQueue, WlsJmsQueue newQueue) {
		super("Modifying WebLogic Queue " + newQueue + " on server " + server + " in module " + oldQueue.getParentModule().getName(), server.getDomain(),
				STEP_RESOURCES_PATH + "configure-jms-queue.py", getArgs(server, oldQueue, newQueue));
	}

	private static String[] getArgs(WlsServer server, WlsJmsQueue oldQueue, WlsJmsQueue newQueue) {
		if (newQueue.getParentModule() == null) {
			throw new ResolutionException("Weblogic Queue " + newQueue + " is not associated with any Jms Module");
		}

		List<String> args = new ArrayList<String>();

		args.add(newQueue.getParentModule().getName());
		args.add(server.getName());
		args.add(newQueue.getName());
		args.add(newQueue.getJndiName());
		args.add(String.valueOf(newQueue.getRedeliveryDelayOverride()));
		args.add(String.valueOf(newQueue.getRedeliveryLimits()));
		args.add(newQueue.getExpirationPolicy().name());
		args.add(newQueue.getExpirationLoggingFormat());
		String errorQueueName = "";
		if (newQueue.getErrorQueue() != null) {
			errorQueueName = newQueue.getErrorQueue().getName();
		}
		args.add(errorQueueName);
		String oldErrorQueueName = "";
		if (oldQueue.getErrorQueue() != null) {
			oldErrorQueueName = oldQueue.getErrorQueue().getName();
		}
		args.add(oldErrorQueueName);

		return args.toArray(new String[args.size()]);
	}

}