/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.mapping.EjbJarMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.StartApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.StopApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsUndeployArtifactStep;

public class EjbToWlsServerMapper extends Mapper<EjbJar, EjbJarMapping, WlsServer> {

	public EjbToWlsServerMapper(Change<Deployment> c) {
			super(c);
	}

	public void generateUndeploySteps(List<Step> steps) {
		for (EjbJarMapping m : getDeletedMappings()) {
			steps.add(new StopApplicationStep((WlsServer) m.getTarget(), (EjbJar) m.getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsServer) m.getTarget(), (EjbJar) m.getSource()));
		}
		for (Pair<EjbJarMapping, EjbJarMapping> mPair : getModifiedMappings()) {
			steps.add(new StopApplicationStep((WlsServer) mPair.getFirst().getTarget(), (EjbJar) mPair.getFirst().getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsServer) mPair.getFirst().getTarget(), (EjbJar) mPair.getFirst().getSource()));
		}
	}

	public void generateDeploySteps(List<Step> steps) {
		for (Pair<EjbJarMapping, EjbJarMapping> mPair : getModifiedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsServer) mPair.getFirst().getTarget(), (EjbJar) mPair.getFirst().getSource()));
		}
		for (EjbJarMapping m : getAddedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsServer) m.getTarget(), (EjbJar) m.getSource()));
		}
	}

	public void generateStartSteps(List<Step> steps) {
		for (Pair<EjbJarMapping, EjbJarMapping> mPair : getModifiedMappings()) {
			steps.add(new StartApplicationStep((WlsServer) mPair.getFirst().getTarget(), (EjbJar) mPair.getFirst().getSource()));
		}
		for (EjbJarMapping m : getAddedMappings()) {
			steps.add(new StartApplicationStep((WlsServer) m.getTarget(), (EjbJar) m.getSource()));
		}
	}

}
