package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;

public class JmsMapperUtils {

	public static String getJmsModuleName(Change<Deployment> change, WlsTarget target) {
		if (change.getNewRevision() != null) {
			return getJmsModuleNameFromDeployment(change.getNewRevision(), target);
		} else {
			return getJmsModuleNameFromDeployment(change.getOldRevision(), target);
		}
	}

	private static String getJmsModuleNameFromDeployment(Deployment d, WlsTarget target) {
		return sanitizeLabel(d.getSource().getApplication().getLabel()) + "-" + sanitizeLabel(target.getLabel());
	}

	private static String sanitizeLabel(String label) {
		return label.replace(' ', '_');
	}
	
	public static Set<WlsDomain> getDomains(Collection<WlsTarget> targets) {
		Set<WlsDomain> domains = new HashSet<WlsDomain>();
		for (WlsTarget each : targets) {
			domains.add(each.getDomain());
		}
		return domains;
	}

}
