package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Creates a JMS Module.
 */
@SuppressWarnings("serial")
public class CreateWlsJmsModuleStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-jms-module.py";

	public CreateWlsJmsModuleStep(WlsServer server, String moduleName) {
		super("Create JMS Module " + moduleName + " on domain " + server.getDomain() + " targeted at server " + server, server.getDomain(),
				SCRIPT_RESOURCE_PATH, moduleName, server.getTargetObjectName());
	}

	public CreateWlsJmsModuleStep(WlsCluster cluster, String moduleName) {
		super("Create JMS Module " + moduleName + " on domain " + cluster.getDomain() + " targeted at cluster " + cluster, cluster.getDomain(),
				SCRIPT_RESOURCE_PATH, moduleName, cluster.getTargetObjectName());
	}

}
