/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;

@SuppressWarnings("serial")
public class ModifyWlsJmsQueueStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "modify-jms-queue.py";

	public ModifyWlsJmsQueueStep(WlsDomain domain, String jmsModuleName, WlsJmsQueue modifiedQueue) {
		super("Modify JMS Queue " + modifiedQueue + " in module " + jmsModuleName + " on domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(domain,
				jmsModuleName, modifiedQueue));
	}

	private static String[] getArgs(WlsDomain domain, String jmsModuleName, WlsJmsQueue modifiedQueue) {
		List<String> args = new ArrayList<String>();
		args.add(jmsModuleName);
		args.add(modifiedQueue.getJmsServer().getSubdeploymentName(jmsModuleName));
		args.add(modifiedQueue.getName());
		args.add(modifiedQueue.getJndiName());
		args.add(String.valueOf(modifiedQueue.getRedeliveryDelayOverride()));
		args.add(String.valueOf(modifiedQueue.getRedeliveryLimits()));
		args.add(modifiedQueue.getExpirationPolicy() != null ? modifiedQueue.getExpirationPolicy().name() : "");
		args.add(modifiedQueue.getExpirationLoggingFormat());
		args.add(modifiedQueue.getErrorQueue() != null ? modifiedQueue.getErrorQueue().getName() : "");
		return args.toArray(new String[args.size()]);
	}
}